/*
 * Decompiled with CFR 0.152.
 */
package com.blocklegend001.immersiveores.item.custom.vulpus;

import com.blocklegend001.immersiveores.config.VulpusConfig;
import com.blocklegend001.immersiveores.item.ModItems;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Unit;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.item.equipment.ArmorMaterial;
import net.minecraft.world.item.equipment.ArmorType;
import net.minecraft.world.item.equipment.Equippable;
import org.jetbrains.annotations.Nullable;

public class VulpusArmor
extends Item {
    public VulpusArmor(ArmorMaterial material, ArmorType type, Item.Properties settings) {
        super(VulpusArmor.computeSettings(material, type, (Boolean)VulpusConfig.UNBREAKABLE_VULPUS.get(), (Integer)VulpusConfig.DURABILITY_VULPUS.get(), settings));
    }

    private static Item.Properties computeSettings(ArmorMaterial material, ArmorType type, boolean unbreakable, int durability, Item.Properties settings) {
        settings.humanoidArmor(material, ArmorType.BODY).attributes(material.createAttributes(type)).enchantable(material.enchantmentValue()).component(DataComponents.EQUIPPABLE, (Object)Equippable.builder((EquipmentSlot)type.getSlot()).setEquipSound(material.equipSound()).setAsset(material.assetId()).build()).durability(durability);
        if (unbreakable) {
            settings.component(DataComponents.UNBREAKABLE, (Object)Unit.INSTANCE);
        }
        return settings;
    }

    public void inventoryTick(ItemStack stack, ServerLevel level, Entity entity, @Nullable EquipmentSlot equipmentSlot) {
        super.inventoryTick(stack, level, entity, equipmentSlot);
        if (!level.isClientSide() && entity instanceof Player) {
            Player player = (Player)entity;
            if (player.getItemBySlot(EquipmentSlot.FEET).getItem() == ModItems.VULPUS_BOOTS.get()) {
                if (((Boolean)VulpusConfig.SPEED_II_VULPUS_ARMOR.get()).booleanValue()) {
                    player.addEffect(new MobEffectInstance(MobEffects.SPEED, 400, 1, false, false));
                }
                if (((Boolean)VulpusConfig.JUMP_II_VULPUS_ARMOR.get()).booleanValue()) {
                    player.addEffect(new MobEffectInstance(MobEffects.JUMP_BOOST, 400, 1, false, false));
                }
                if (((Boolean)VulpusConfig.FIRE_RESISTANCE_VULPUS_ARMOR.get()).booleanValue()) {
                    player.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 400, 0, false, false));
                }
                if (!player.onGround() && player.fallDistance >= 1.0 && ((Boolean)VulpusConfig.IMMUNE_TO_FALL_DAMAGE_VULPUS_ARMOR.get()).booleanValue()) {
                    player.fallDistance = 0.0;
                }
            }
            if (player.getItemBySlot(EquipmentSlot.CHEST).getItem() == ModItems.VULPUS_CHESTPLATE.get()) {
                player.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 400, 1, false, false));
            }
            if (player.getItemBySlot(EquipmentSlot.HEAD).getItem() == ModItems.VULPUS_HELMET.get()) {
                if (((Boolean)VulpusConfig.NIGHT_VISION_VULPUS_ARMOR.get()).booleanValue()) {
                    player.addEffect(new MobEffectInstance(MobEffects.NIGHT_VISION, 400, 0, false, false));
                }
                if (((Boolean)VulpusConfig.FIRE_RESISTANCE_VULPUS_ARMOR.get()).booleanValue()) {
                    player.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 400, 0, false, false));
                }
            }
            if (player.getItemBySlot(EquipmentSlot.LEGS).getItem() == ModItems.VULPUS_LEGGINGS.get()) {
                if (((Boolean)VulpusConfig.FIRE_RESISTANCE_VULPUS_ARMOR.get()).booleanValue()) {
                    player.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 400, 0, false, false));
                }
                if (((Boolean)VulpusConfig.NEVER_LOSE_HUNGER_VULPUS_ARMOR.get()).booleanValue()) {
                    player.addEffect(new MobEffectInstance(MobEffects.SATURATION, 400, 99, false, false));
                }
            }
        }
    }

    public void onCraftedBy(ItemStack stack, Player player) {
        super.onCraftedBy(stack, player);
        Item resultItem = stack.getItem();
        for (int i = 1; i <= 9; ++i) {
            Component customName;
            ItemStack ingredient = player.containerMenu.getSlot(i).getItem();
            Item ingredientItem = ingredient.getItem();
            if (!(resultItem == ModItems.VULPUS_HELMET.get() && ingredientItem == ModItems.VIBRANIUM_HELMET.get() || resultItem == ModItems.VULPUS_CHESTPLATE.get() && ingredientItem == ModItems.VIBRANIUM_CHESTPLATE.get() || resultItem == ModItems.VULPUS_LEGGINGS.get() && ingredientItem == ModItems.VIBRANIUM_LEGGINGS.get()) && (resultItem != ModItems.VULPUS_BOOTS.get() || ingredientItem != ModItems.VIBRANIUM_BOOTS.get())) continue;
            ItemEnchantments ench = (ItemEnchantments)ingredient.get(DataComponents.ENCHANTMENTS);
            if (ench != null) {
                stack.set(DataComponents.ENCHANTMENTS, (Object)ench);
            }
            if ((customName = (Component)ingredient.get(DataComponents.CUSTOM_NAME)) == null) break;
            stack.set(DataComponents.CUSTOM_NAME, (Object)customName);
            break;
        }
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext p_333372_, TooltipDisplay p_396484_, Consumer<Component> consumer, TooltipFlag p_41424_) {
        super.appendHoverText(pStack, p_333372_, p_396484_, consumer, p_41424_);
        if (Screen.hasShiftDown()) {
            if (ModItems.VULPUS_BOOTS.get() == pStack.getItem()) {
                if (((Boolean)VulpusConfig.UNBREAKABLE_VULPUS.get()).booleanValue()) {
                    consumer.accept((Component)Component.translatable((String)"tooltip.immersiveores.unbreakble.tooltip").withStyle(ChatFormatting.RED));
                }
                consumer.accept((Component)Component.translatable((String)"tooltip.immersiveores.immunetofire.tooltip").withStyle(ChatFormatting.RED));
                if (((Boolean)VulpusConfig.SPEED_II_VULPUS_ARMOR.get()).booleanValue()) {
                    consumer.accept((Component)Component.translatable((String)"tooltip.immersiveores.speed2.tooltip").withStyle(ChatFormatting.RED));
                }
                if (((Boolean)VulpusConfig.JUMP_II_VULPUS_ARMOR.get()).booleanValue()) {
                    consumer.accept((Component)Component.translatable((String)"tooltip.immersiveores.jump2.tooltip").withStyle(ChatFormatting.RED));
                }
                if (((Boolean)VulpusConfig.CAN_WALK_ON_POWDERED_SNOW_VULPUS.get()).booleanValue()) {
                    consumer.accept((Component)Component.translatable((String)"tooltip.immersiveores.canwalkonpowderedsnow.tooltip").withStyle(ChatFormatting.RED));
                }
                if (((Boolean)VulpusConfig.MAKES_PIGLINS_NEUTRAL_VULPUS.get()).booleanValue()) {
                    consumer.accept((Component)Component.translatable((String)"tooltip.immersiveores.immunetopiglin.tooltip").withStyle(ChatFormatting.RED));
                }
                if (((Boolean)VulpusConfig.FIRE_RESISTANCE_VULPUS_ARMOR.get()).booleanValue()) {
                    consumer.accept((Component)Component.translatable((String)"tooltip.immersiveores.playerimmunetofire.tooltip").withStyle(ChatFormatting.RED));
                }
                if (((Boolean)VulpusConfig.IMMUNE_TO_FALL_DAMAGE_VULPUS_ARMOR.get()).booleanValue()) {
                    consumer.accept((Component)Component.translatable((String)"tooltip.immersiveores.immunetofalldamage.tooltip").withStyle(ChatFormatting.RED));
                }
            }
            if (ModItems.VULPUS_CHESTPLATE.get() == pStack.getItem()) {
                consumer.accept((Component)Component.translatable((String)"tooltip.immersiveores.unbreakble.tooltip").withStyle(ChatFormatting.RED));
                consumer.accept((Component)Component.translatable((String)"tooltip.immersiveores.immunetofire.tooltip").withStyle(ChatFormatting.RED));
                if (((Boolean)VulpusConfig.MAKES_PIGLINS_NEUTRAL_VULPUS.get()).booleanValue()) {
                    consumer.accept((Component)Component.translatable((String)"tooltip.immersiveores.immunetopiglin.tooltip").withStyle(ChatFormatting.RED));
                }
                if (((Boolean)VulpusConfig.FIRE_RESISTANCE_VULPUS_ARMOR.get()).booleanValue()) {
                    consumer.accept((Component)Component.translatable((String)"tooltip.immersiveores.playerimmunetofire.tooltip").withStyle(ChatFormatting.RED));
                }
            }
            if (ModItems.VULPUS_HELMET.get() == pStack.getItem()) {
                consumer.accept((Component)Component.translatable((String)"tooltip.immersiveores.unbreakble.tooltip").withStyle(ChatFormatting.RED));
                consumer.accept((Component)Component.translatable((String)"tooltip.immersiveores.immunetofire.tooltip").withStyle(ChatFormatting.RED));
                if (((Boolean)VulpusConfig.NIGHT_VISION_VULPUS_ARMOR.get()).booleanValue()) {
                    consumer.accept((Component)Component.translatable((String)"tooltip.immersiveores.nightvision.tooltip").withStyle(ChatFormatting.RED));
                }
                if (((Boolean)VulpusConfig.MAKES_PIGLINS_NEUTRAL_VULPUS.get()).booleanValue()) {
                    consumer.accept((Component)Component.translatable((String)"tooltip.immersiveores.immunetopiglin.tooltip").withStyle(ChatFormatting.RED));
                }
                if (((Boolean)VulpusConfig.FIRE_RESISTANCE_VULPUS_ARMOR.get()).booleanValue()) {
                    consumer.accept((Component)Component.translatable((String)"tooltip.immersiveores.playerimmunetofire.tooltip").withStyle(ChatFormatting.RED));
                }
            }
            if (ModItems.VULPUS_LEGGINGS.get() == pStack.getItem()) {
                consumer.accept((Component)Component.translatable((String)"tooltip.immersiveores.unbreakble.tooltip").withStyle(ChatFormatting.RED));
                consumer.accept((Component)Component.translatable((String)"tooltip.immersiveores.immunetofire.tooltip").withStyle(ChatFormatting.RED));
                if (((Boolean)VulpusConfig.MAKES_PIGLINS_NEUTRAL_VULPUS.get()).booleanValue()) {
                    consumer.accept((Component)Component.translatable((String)"tooltip.immersiveores.immunetopiglin.tooltip").withStyle(ChatFormatting.RED));
                }
                if (((Boolean)VulpusConfig.FIRE_RESISTANCE_VULPUS_ARMOR.get()).booleanValue()) {
                    consumer.accept((Component)Component.translatable((String)"tooltip.immersiveores.playerimmunetofire.tooltip").withStyle(ChatFormatting.RED));
                }
                if (((Boolean)VulpusConfig.NEVER_LOSE_HUNGER_VULPUS_ARMOR.get()).booleanValue()) {
                    consumer.accept((Component)Component.translatable((String)"tooltip.immersiveores.nerverlosehunger.tooltip").withStyle(ChatFormatting.RED));
                }
            }
        } else {
            consumer.accept((Component)Component.translatable((String)"tooltip.immersiveores.pressshiftformoreinfo.tooltip").withStyle(ChatFormatting.RED));
        }
    }

    public boolean makesPiglinsNeutral(ItemStack stack, LivingEntity wearer) {
        return (Boolean)VulpusConfig.CAN_WALK_ON_POWDERED_SNOW_VULPUS.get();
    }

    public boolean canWalkOnPowderedSnow(ItemStack stack, LivingEntity wearer) {
        return (Boolean)VulpusConfig.MAKES_PIGLINS_NEUTRAL_VULPUS.get();
    }
}

