/*
 * Decompiled with CFR 0.152.
 */
package com.blocklegend001.immersiveores.item;

import com.blocklegend001.immersiveores.config.EnderiumConfig;
import com.blocklegend001.immersiveores.config.VibraniumConfig;
import com.blocklegend001.immersiveores.config.VulpusConfig;
import com.blocklegend001.immersiveores.item.ModItems;
import java.util.EnumMap;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public final class ModArmorMaterials {
    public static final Holder<ArmorMaterial> VIBRANIUM = ModArmorMaterials.register("vibranium", (EnumMap)Util.make(new EnumMap(ArmorItem.Type.class), attribute -> {
        attribute.put(ArmorItem.Type.BOOTS, (Integer)VibraniumConfig.protectionValueVibraniumBoots.get());
        attribute.put(ArmorItem.Type.LEGGINGS, (Integer)VibraniumConfig.protectionValueVibraniumLeggings.get());
        attribute.put(ArmorItem.Type.CHESTPLATE, (Integer)VibraniumConfig.protectionValueVibraniumChestplate.get());
        attribute.put(ArmorItem.Type.HELMET, (Integer)VibraniumConfig.protectionValueVibraniumHelmet.get());
    }), (Integer)VibraniumConfig.enchantmentValueVibraniumArmor.get(), ((Integer)VibraniumConfig.toughnessValueVibraniumArmor.get()).intValue(), ((Integer)VibraniumConfig.knockbackResistanceValueVibraniumArmor.get()).intValue(), (Item)ModItems.VIBRANIUM_INGOT.get());
    public static final Holder<ArmorMaterial> VULPUS = ModArmorMaterials.register("vulpus", (EnumMap)Util.make(new EnumMap(ArmorItem.Type.class), attribute -> {
        attribute.put(ArmorItem.Type.BOOTS, (Integer)VulpusConfig.protectionValueVulpusBoots.get());
        attribute.put(ArmorItem.Type.LEGGINGS, (Integer)VulpusConfig.protectionValueVulpusLeggings.get());
        attribute.put(ArmorItem.Type.CHESTPLATE, (Integer)VulpusConfig.protectionValueVulpusChestplate.get());
        attribute.put(ArmorItem.Type.HELMET, (Integer)VulpusConfig.protectionValueVulpusHelmet.get());
    }), (Integer)VulpusConfig.enchantmentValueVulpusArmor.get(), ((Integer)VulpusConfig.toughnessValueVulpusArmor.get()).intValue(), ((Integer)VulpusConfig.knockbackResistanceValueVulpusArmor.get()).intValue(), (Item)ModItems.VULPUS_INGOT.get());
    public static final Holder<ArmorMaterial> ENDERIUM = ModArmorMaterials.register("enderium", (EnumMap)Util.make(new EnumMap(ArmorItem.Type.class), attribute -> {
        attribute.put(ArmorItem.Type.BOOTS, (Integer)EnderiumConfig.protectionValueEnderiumBoots.get());
        attribute.put(ArmorItem.Type.LEGGINGS, (Integer)EnderiumConfig.protectionValueEnderiumLeggings.get());
        attribute.put(ArmorItem.Type.CHESTPLATE, (Integer)EnderiumConfig.protectionValueEnderiumChestplate.get());
        attribute.put(ArmorItem.Type.HELMET, (Integer)EnderiumConfig.protectionValueEnderiumHelmet.get());
    }), (Integer)EnderiumConfig.enchantmentValueEnderiumArmor.get(), ((Integer)EnderiumConfig.toughnessValueEnderiumArmor.get()).intValue(), ((Integer)EnderiumConfig.knockbackResistanceValueEnderiumArmor.get()).intValue(), (Item)ModItems.ENDERIUM_INGOT.get());

    private static Holder<ArmorMaterial> register(String name, EnumMap<ArmorItem.Type, Integer> typeProtections, int enchantability, float toughness, float knockbackResistance, Item repairItem) {
        ResourceLocation loc = ResourceLocation.fromNamespaceAndPath((String)"immersiveores", (String)name);
        Holder soundEvent = SoundEvents.ARMOR_EQUIP_NETHERITE;
        Supplier<Ingredient> repairIngredient = () -> Ingredient.of((ItemLike[])new ItemLike[]{repairItem});
        List<ArmorMaterial.Layer> layers = List.of(new ArmorMaterial.Layer(loc));
        EnumMap<ArmorItem.Type, Integer> typeMap = new EnumMap<ArmorItem.Type, Integer>(ArmorItem.Type.class);
        for (ArmorItem.Type type : ArmorItem.Type.values()) {
            typeMap.put(type, typeProtections.get(type));
        }
        return Registry.registerForHolder((Registry)BuiltInRegistries.ARMOR_MATERIAL, (ResourceLocation)loc, (Object)new ArmorMaterial(typeProtections, enchantability, soundEvent, repairIngredient, layers, toughness, knockbackResistance));
    }
}

