/*
 * Decompiled with CFR 0.152.
 */
package com.blocklegend001.immersiveores.item.custom.vibranium;

import com.blocklegend001.immersiveores.config.VibraniumConfig;
import com.blocklegend001.immersiveores.util.map.ArrowCountMap;
import com.blocklegend001.immersiveores.util.tools.bow.BowTier;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.Unbreakable;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class VibraniumBow
extends BowItem {
    private final BowTier tier;
    private final int ARROW_COUNT = (Integer)VibraniumConfig.arrowCountVibraniumBow.get();

    private static Item.Properties createSettings(boolean unbreakable, int durability) {
        Item.Properties settings = new Item.Properties().durability(durability);
        if (unbreakable) {
            settings.component(DataComponents.UNBREAKABLE, (Object)new Unbreakable(true));
        }
        return settings;
    }

    public VibraniumBow(BowTier tier, Item.Properties properties) {
        super(VibraniumBow.createSettings((Boolean)VibraniumConfig.unbreakableVibranium.get(), (Integer)VibraniumConfig.durabilityVibranium.get()));
        this.tier = tier;
    }

    public AbstractArrow customArrow(AbstractArrow arrow) {
        arrow.setBaseDamage(arrow.getBaseDamage() + this.tier.getAttackDamageBonus());
        return arrow;
    }

    public int getEnchantmentValue() {
        return this.tier.getEnchantmentValue();
    }

    public boolean isEnchantable(ItemStack p_41456_) {
        return true;
    }

    public void releaseUsing(ItemStack stack, Level world, LivingEntity entityLiving, int timeLeft) {
        if (entityLiving instanceof Player) {
            Player player = (Player)entityLiving;
            ItemStack arrowStack = player.getProjectile(stack);
            Registry enchantmentRegistry = world.registryAccess().registryOrThrow(Registries.ENCHANTMENT);
            Holder.Reference enchantmentReference = enchantmentRegistry.getHolderOrThrow(Enchantments.INFINITY);
            boolean hasInfinity = EnchantmentHelper.getItemEnchantmentLevel((Holder)enchantmentReference, (ItemStack)player.getMainHandItem()) > 0;
            Holder.Reference enchantmentReferencePower = enchantmentRegistry.getHolderOrThrow(Enchantments.INFINITY);
            int powerLevel = EnchantmentHelper.getItemEnchantmentLevel((Holder)enchantmentReferencePower, (ItemStack)player.getMainHandItem());
            Holder.Reference enchantmentReferencePunch = enchantmentRegistry.getHolderOrThrow(Enchantments.INFINITY);
            int punchLevel = EnchantmentHelper.getItemEnchantmentLevel((Holder)enchantmentReferencePunch, (ItemStack)player.getMainHandItem());
            int charge = this.getUseDuration(stack, entityLiving) - timeLeft;
            float arrowVelocity = VibraniumBow.getPowerForTime((int)charge);
            if ((double)arrowVelocity >= 0.1) {
                if (!world.isClientSide) {
                    boolean isPrimaryArrow = true;
                    for (int i = 0; i < this.ARROW_COUNT; ++i) {
                        ArrowItem arrowItem = (ArrowItem)(arrowStack.getItem() instanceof ArrowItem ? arrowStack.getItem() : Items.ARROW);
                        AbstractArrow arrowEntity = arrowItem.createArrow(world, arrowStack, (LivingEntity)player, stack);
                        arrowEntity.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, arrowVelocity * 3.0f, 1.0f);
                        if (powerLevel > 0) {
                            arrowEntity.setBaseDamage(arrowEntity.getBaseDamage() + ((double)powerLevel * 0.5 + 1.0));
                        }
                        if (punchLevel > 0) {
                            double resistance = Math.max(0.0, 1.0 - entityLiving.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE));
                            double factor = (double)punchLevel * 0.6 * resistance;
                            Vec3 knockbackVec = arrowEntity.getDeltaMovement().normalize().multiply(factor, factor, factor);
                            arrowEntity.addDeltaMovement(new Vec3(knockbackVec.x, 0.1, knockbackVec.z));
                        }
                        if (arrowVelocity == 1.0f) {
                            arrowEntity.setCritArrow(true);
                        }
                        if (isPrimaryArrow) {
                            arrowEntity.pickup = hasInfinity ? AbstractArrow.Pickup.DISALLOWED : AbstractArrow.Pickup.ALLOWED;
                            isPrimaryArrow = false;
                        } else {
                            arrowEntity.pickup = AbstractArrow.Pickup.DISALLOWED;
                        }
                        world.addFreshEntity((Entity)arrowEntity);
                    }
                }
                world.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ARROW_SHOOT, SoundSource.PLAYERS, 1.0f, 1.0f / (player.getRandom().nextFloat() * 0.4f + 1.2f) + arrowVelocity * 0.5f);
                if (!player.getAbilities().instabuild && !hasInfinity) {
                    arrowStack.shrink(1);
                    if (arrowStack.isEmpty()) {
                        player.getInventory().removeItem(arrowStack);
                    }
                }
                player.getMainHandItem().hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)InteractionHand.MAIN_HAND));
            }
        }
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext pContext, List<Component> components, TooltipFlag pTooltipFlag) {
        int arrowCount = this.getArrowCount(pStack);
        ChatFormatting color = ChatFormatting.LIGHT_PURPLE;
        if (Screen.hasShiftDown()) {
            MutableComponent damage = Component.literal((String)("+" + this.tier.getAttackDamageBonus() + " ")).append((Component)Component.translatable((String)"tooltip.immersiveores.damage.tooltip")).withStyle(color);
            components.add((Component)damage);
            if (((Boolean)VibraniumConfig.unbreakableVibranium.get()).booleanValue()) {
                MutableComponent unbreakable = Component.translatable((String)"tooltip.immersiveores.unbreakble.tooltip").withStyle(color);
                components.add((Component)unbreakable);
            }
            MutableComponent fireImmune = Component.translatable((String)"tooltip.immersiveores.immunetofire.tooltip").withStyle(color);
            components.add((Component)fireImmune);
            MutableComponent arrow = Component.literal((String)"Can shoot ").withStyle(color).append((Component)Component.literal((String)String.valueOf(arrowCount)).withStyle(ChatFormatting.YELLOW)).append((Component)Component.literal((String)" Arrows").withStyle(color));
            components.add((Component)arrow);
        } else {
            MutableComponent pressShift = Component.translatable((String)"tooltip.immersiveores.pressshiftformoreinfo.tooltip").withStyle(color);
            components.add((Component)pressShift);
        }
    }

    private int getArrowCount(ItemStack stack) {
        if (ArrowCountMap.getVibraniumBowArrowCount().containsKey(stack.getItem())) {
            return ArrowCountMap.getVibraniumBowArrowCount().get(stack.getItem());
        }
        return 0;
    }
}

