/*
 * Decompiled with CFR 0.152.
 */
package com.blocklegend001.immersiveores.item;

import com.blocklegend001.immersiveores.config.EnderiumConfig;
import com.blocklegend001.immersiveores.config.VibraniumConfig;
import com.blocklegend001.immersiveores.config.VulpusConfig;
import com.blocklegend001.immersiveores.item.ModItems;
import java.util.EnumMap;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public final class ModArmorMaterials {
    public static final Holder<ArmorMaterial> VIBRANIUM = ModArmorMaterials.register("vibranium", (EnumMap)Util.make(new EnumMap(ArmorItem.Type.class), attribute -> {
        attribute.put(ArmorItem.Type.BOOTS, (Integer)VibraniumConfig.PROTECTION_VALUE_VIBRANIUM_BOOTS.get());
        attribute.put(ArmorItem.Type.LEGGINGS, (Integer)VibraniumConfig.PROTECTION_VALUE_VIBRANIUM_LEGGINGS.get());
        attribute.put(ArmorItem.Type.CHESTPLATE, (Integer)VibraniumConfig.PROTECTION_VALUE_VIBRANIUM_CHESTPLATE.get());
        attribute.put(ArmorItem.Type.HELMET, (Integer)VibraniumConfig.PROTECTION_VALUE_VIBRANIUM_HELMET.get());
    }), (Integer)VibraniumConfig.ENCHANTMENT_VALUE_VIBRANIUM_ARMOR.get(), ((Integer)VibraniumConfig.TOUGHNESS_VALUE_VIBRANIUM_ARMOR.get()).intValue(), (float)VibraniumConfig.KNOCKBACK_RESISTANCE_VALUE_VIBRANIUM_ARMOR.getAsDouble(), (Item)ModItems.VIBRANIUM_INGOT.get());
    public static final Holder<ArmorMaterial> VULPUS = ModArmorMaterials.register("vulpus", (EnumMap)Util.make(new EnumMap(ArmorItem.Type.class), attribute -> {
        attribute.put(ArmorItem.Type.BOOTS, (Integer)VulpusConfig.PROTECTION_VALUE_VULPUS_BOOTS.get());
        attribute.put(ArmorItem.Type.LEGGINGS, (Integer)VulpusConfig.PROTECTION_VALUE_VULPUS_LEGGINGS.get());
        attribute.put(ArmorItem.Type.CHESTPLATE, (Integer)VulpusConfig.PROTECTION_VALUE_VULPUS_CHESTPLATE.get());
        attribute.put(ArmorItem.Type.HELMET, (Integer)VulpusConfig.PROTECTION_VALUE_VULPUS_HELMET.get());
    }), (Integer)VulpusConfig.ENCHANTMENT_VALUE_VULPUS_ARMOR.get(), ((Integer)VulpusConfig.TOUGHNESS_VALUE_VULPUS_ARMOR.get()).intValue(), (float)VulpusConfig.KNOCKBACK_RESISTANCE_VALUE_VULPUS_ARMOR.getAsDouble(), (Item)ModItems.VULPUS_INGOT.get());
    public static final Holder<ArmorMaterial> ENDERIUM = ModArmorMaterials.register("enderium", (EnumMap)Util.make(new EnumMap(ArmorItem.Type.class), attribute -> {
        attribute.put(ArmorItem.Type.BOOTS, (Integer)EnderiumConfig.PROTECTION_VALUE_ENDERIUM_BOOTS.get());
        attribute.put(ArmorItem.Type.LEGGINGS, (Integer)EnderiumConfig.PROTECTION_VALUE_ENDERIUM_LEGGINGS.get());
        attribute.put(ArmorItem.Type.CHESTPLATE, (Integer)EnderiumConfig.PROTECTION_VALUE_ENDERIUM_CHESTPLATE.get());
        attribute.put(ArmorItem.Type.HELMET, (Integer)EnderiumConfig.PROTECTION_VALUE_ENDERIUM_HELMET.get());
    }), (Integer)EnderiumConfig.ENCHANTMENT_VALUE_ENDERIUM_ARMOR.get(), ((Integer)EnderiumConfig.TOUGHNESS_VALUE_ENDERIUM_ARMOR.get()).intValue(), (float)EnderiumConfig.KNOCKBACK_RESISTANCE_VALUE_ENDERIUM_ARMOR.getAsDouble(), (Item)ModItems.ENDERIUM_INGOT.get());

    private static Holder<ArmorMaterial> register(String name, EnumMap<ArmorItem.Type, Integer> typeProtections, int enchantability, float toughness, float knockbackResistance, Item repairItem) {
        ResourceLocation loc = ResourceLocation.fromNamespaceAndPath((String)"immersiveores", (String)name);
        Holder soundEvent = SoundEvents.ARMOR_EQUIP_NETHERITE;
        Supplier<Ingredient> repairIngredient = () -> Ingredient.of((ItemLike[])new ItemLike[]{repairItem});
        List<ArmorMaterial.Layer> layers = List.of(new ArmorMaterial.Layer(loc));
        EnumMap<ArmorItem.Type, Integer> typeMap = new EnumMap<ArmorItem.Type, Integer>(ArmorItem.Type.class);
        for (ArmorItem.Type type : ArmorItem.Type.values()) {
            typeMap.put(type, typeProtections.get(type));
        }
        return Registry.registerForHolder((Registry)BuiltInRegistries.ARMOR_MATERIAL, (ResourceLocation)loc, (Object)new ArmorMaterial(typeProtections, enchantability, soundEvent, repairIngredient, layers, toughness, knockbackResistance));
    }
}

