/*
 * Decompiled with CFR 0.152.
 */
package com.blocklegend001.immersiveores.item.custom.enderium;

import com.blocklegend001.immersiveores.config.EnderiumConfig;
import com.blocklegend001.immersiveores.item.ModToolTiers;
import com.blocklegend001.immersiveores.item.custom.base.Hammer;
import com.blocklegend001.immersiveores.util.map.RadiusMap;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.Unbreakable;

public class EnderiumHammer
extends Hammer {
    private static Item.Properties createSettings(boolean unbreakable, int durability) {
        Item.Properties settings = new Item.Properties().durability(durability).attributes(EnderiumHammer.createAttributes((Tier)ModToolTiers.ENDERIUM, (float)((Integer)EnderiumConfig.ATTACK_DAMAGE_ENDERIUM_HAMMER.get()).intValue(), (float)((float)((Double)EnderiumConfig.ATTACK_SPEED_ENDERIUM_HAMMER.get()).doubleValue())));
        if (unbreakable) {
            settings.component(DataComponents.UNBREAKABLE, (Object)new Unbreakable(true));
        }
        return settings;
    }

    public EnderiumHammer(Tier pTier, int pAttackDamageModifier, float pAttackSpeedModifier, Item.Properties pProperties) {
        super(pTier, pAttackDamageModifier, pAttackSpeedModifier, EnderiumHammer.createSettings((Boolean)EnderiumConfig.UNBREAKABLE_ENDERIUM.get(), (Integer)EnderiumConfig.DURABILITY_ENDERIUM.get()));
    }

    public Component getName(ItemStack stack) {
        return super.getName(stack).copy().withStyle(ChatFormatting.DARK_AQUA);
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext pContext, List<Component> components, TooltipFlag pTooltipFlag) {
        int radius = this.getRadiusForHammer(pStack);
        int widht = radius * 2 + 1;
        if (Screen.hasShiftDown()) {
            if (((Boolean)EnderiumConfig.UNBREAKABLE_ENDERIUM.get()).booleanValue()) {
                components.add((Component)Component.translatable((String)"tooltip.immersiveores.unbreakble.tooltip").withStyle(ChatFormatting.DARK_AQUA));
            }
            components.add((Component)Component.translatable((String)"tooltip.immersiveores.immunetofire.tooltip").withStyle(ChatFormatting.DARK_AQUA));
            MutableComponent text = Component.literal((String)"Dig area: ").withStyle(ChatFormatting.DARK_AQUA).append((Component)Component.literal((String)(widht + "x1")).withStyle(ChatFormatting.YELLOW));
            components.add((Component)text);
        } else {
            components.add((Component)Component.translatable((String)"tooltip.immersiveores.pressshiftformoreinfo.tooltip").withStyle(ChatFormatting.DARK_AQUA));
        }
    }

    private int getRadiusForHammer(ItemStack stack) {
        if (RadiusMap.getHammerRadius().containsKey(stack.getItem())) {
            return RadiusMap.getHammerRadius().get(stack.getItem());
        }
        return 0;
    }
}

