/*
 * Decompiled with CFR 0.152.
 */
package com.blocklegend001.immersiveores.item.custom.vulpus;

import com.blocklegend001.immersiveores.config.VulpusConfig;
import com.blocklegend001.immersiveores.item.ModArmorMaterials;
import com.blocklegend001.immersiveores.item.ModItems;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.Unbreakable;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;

public class VulpusArmor
extends ArmorItem {
    private static Item.Properties createSettings(boolean unbreakable, int durability) {
        Item.Properties settings = new Item.Properties().durability(durability);
        if (unbreakable) {
            settings.component(DataComponents.UNBREAKABLE, (Object)new Unbreakable(true));
        }
        return settings;
    }

    public VulpusArmor(Holder<ArmorMaterial> pMaterial, ArmorItem.Type pType, Item.Properties pProperties) {
        super(pMaterial, pType, VulpusArmor.createSettings((Boolean)VulpusConfig.UNBREAKABLE_VULPUS.get(), (Integer)VulpusConfig.DURABILITY_VULPUS.get()));
    }

    public Component getName(ItemStack stack) {
        return super.getName(stack).copy().withStyle(ChatFormatting.RED);
    }

    public boolean isEnchantable(ItemStack p_41456_) {
        return true;
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int pSlotId, boolean pIsSelected) {
        if (!level.isClientSide() && entity instanceof Player) {
            Player player = (Player)entity;
            if (player.getItemBySlot(EquipmentSlot.FEET).getItem() == ModItems.VULPUS_BOOTS.get()) {
                if (((Boolean)VulpusConfig.SPEED_II_VULPUS_ARMOR.get()).booleanValue()) {
                    player.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 0, 1, false, false));
                }
                if (((Boolean)VulpusConfig.JUMP_II_VULPUS_ARMOR.get()).booleanValue()) {
                    player.addEffect(new MobEffectInstance(MobEffects.JUMP, 0, 1, false, false));
                }
                if (((Boolean)VulpusConfig.FIRE_RESISTANCE_VULPUS_ARMOR.get()).booleanValue()) {
                    player.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 0, 0, false, false));
                }
                if (!player.onGround() && player.fallDistance >= 1.0f && ((Boolean)VulpusConfig.IMMUNE_TO_FALL_DAMAGE_VULPUS_ARMOR.get()).booleanValue()) {
                    player.fallDistance = 0.0f;
                }
            }
            if (player.getItemBySlot(EquipmentSlot.CHEST).getItem() == ModItems.VULPUS_CHESTPLATE.get() && ((Boolean)VulpusConfig.FIRE_RESISTANCE_VULPUS_ARMOR.get()).booleanValue()) {
                player.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 400, 0, false, false));
            }
            if (player.getItemBySlot(EquipmentSlot.HEAD).getItem() == ModItems.VULPUS_HELMET.get()) {
                if (((Boolean)VulpusConfig.NIGHT_VISION_VULPUS_ARMOR.get()).booleanValue()) {
                    player.addEffect(new MobEffectInstance(MobEffects.NIGHT_VISION, 400, 0, false, false));
                }
                if (((Boolean)VulpusConfig.FIRE_RESISTANCE_VULPUS_ARMOR.get()).booleanValue()) {
                    player.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 400, 0, false, false));
                }
            }
            if (player.getItemBySlot(EquipmentSlot.LEGS).getItem() == ModItems.VULPUS_LEGGINGS.get()) {
                if (((Boolean)VulpusConfig.FIRE_RESISTANCE_VULPUS_ARMOR.get()).booleanValue()) {
                    player.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 400, 0, false, false));
                }
                if (((Boolean)VulpusConfig.NEVER_LOSE_HUNGER_VULPUS_ARMOR.get()).booleanValue()) {
                    player.addEffect(new MobEffectInstance(MobEffects.SATURATION, 400, 99, false, false));
                }
            }
        }
    }

    public void onCraftedBy(ItemStack stack, Level level, Player player) {
        super.onCraftedBy(stack, level, player);
        for (int i = 1; i <= 9; ++i) {
            Component customName;
            ArmorItem armorItem;
            ItemStack ingredient = player.containerMenu.getSlot(i).getItem();
            Item item = ingredient.getItem();
            if (!(item instanceof ArmorItem) || (armorItem = (ArmorItem)item).getMaterial() != ModArmorMaterials.VIBRANIUM || armorItem.getType() != ((ArmorItem)stack.getItem()).getType()) continue;
            ItemEnchantments ench = (ItemEnchantments)ingredient.get(DataComponents.ENCHANTMENTS);
            if (ench != null) {
                stack.set(DataComponents.ENCHANTMENTS, (Object)ench);
            }
            if ((customName = (Component)ingredient.get(DataComponents.CUSTOM_NAME)) == null) break;
            stack.set(DataComponents.CUSTOM_NAME, (Object)customName);
            break;
        }
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext pContext, List<Component> components, TooltipFlag pTooltipFlag) {
        if (Screen.hasShiftDown()) {
            if (ModItems.VULPUS_BOOTS.get() == pStack.getItem()) {
                if (((Boolean)VulpusConfig.UNBREAKABLE_VULPUS.get()).booleanValue()) {
                    components.add((Component)Component.translatable((String)"tooltip.immersiveores.unbreakble.tooltip").withStyle(ChatFormatting.RED));
                }
                components.add((Component)Component.translatable((String)"tooltip.immersiveores.immunetofire.tooltip").withStyle(ChatFormatting.RED));
                if (((Boolean)VulpusConfig.SPEED_II_VULPUS_ARMOR.get()).booleanValue()) {
                    components.add((Component)Component.translatable((String)"tooltip.immersiveores.speed2.tooltip").withStyle(ChatFormatting.RED));
                }
                if (((Boolean)VulpusConfig.JUMP_II_VULPUS_ARMOR.get()).booleanValue()) {
                    components.add((Component)Component.translatable((String)"tooltip.immersiveores.jump2.tooltip").withStyle(ChatFormatting.RED));
                }
                if (((Boolean)VulpusConfig.CAN_WALK_ON_POWDERED_SNOW_VULPUS.get()).booleanValue()) {
                    components.add((Component)Component.translatable((String)"tooltip.immersiveores.canwalkonpowderedsnow.tooltip").withStyle(ChatFormatting.RED));
                }
                if (((Boolean)VulpusConfig.MAKES_PIGLINS_NEUTRAL_VULPUS.get()).booleanValue()) {
                    components.add((Component)Component.translatable((String)"tooltip.immersiveores.immunetopiglin.tooltip").withStyle(ChatFormatting.RED));
                }
                if (((Boolean)VulpusConfig.FIRE_RESISTANCE_VULPUS_ARMOR.get()).booleanValue()) {
                    components.add((Component)Component.translatable((String)"tooltip.immersiveores.playerimmunetofire.tooltip").withStyle(ChatFormatting.RED));
                }
                if (((Boolean)VulpusConfig.IMMUNE_TO_FALL_DAMAGE_VULPUS_ARMOR.get()).booleanValue()) {
                    components.add((Component)Component.translatable((String)"tooltip.immersiveores.immunetofalldamage.tooltip").withStyle(ChatFormatting.RED));
                }
            }
            if (ModItems.VULPUS_CHESTPLATE.get() == pStack.getItem()) {
                if (((Boolean)VulpusConfig.UNBREAKABLE_VULPUS.get()).booleanValue()) {
                    components.add((Component)Component.translatable((String)"tooltip.immersiveores.unbreakble.tooltip").withStyle(ChatFormatting.RED));
                }
                components.add((Component)Component.translatable((String)"tooltip.immersiveores.immunetofire.tooltip").withStyle(ChatFormatting.RED));
                if (((Boolean)VulpusConfig.MAKES_PIGLINS_NEUTRAL_VULPUS.get()).booleanValue()) {
                    components.add((Component)Component.translatable((String)"tooltip.immersiveores.immunetopiglin.tooltip").withStyle(ChatFormatting.RED));
                }
                if (((Boolean)VulpusConfig.FIRE_RESISTANCE_VULPUS_ARMOR.get()).booleanValue()) {
                    components.add((Component)Component.translatable((String)"tooltip.immersiveores.playerimmunetofire.tooltip").withStyle(ChatFormatting.RED));
                }
            }
            if (ModItems.VULPUS_HELMET.get() == pStack.getItem()) {
                if (((Boolean)VulpusConfig.UNBREAKABLE_VULPUS.get()).booleanValue()) {
                    components.add((Component)Component.translatable((String)"tooltip.immersiveores.unbreakble.tooltip").withStyle(ChatFormatting.RED));
                }
                components.add((Component)Component.translatable((String)"tooltip.immersiveores.immunetofire.tooltip").withStyle(ChatFormatting.RED));
                if (((Boolean)VulpusConfig.NIGHT_VISION_VULPUS_ARMOR.get()).booleanValue()) {
                    components.add((Component)Component.translatable((String)"tooltip.immersiveores.nightvision.tooltip").withStyle(ChatFormatting.RED));
                }
                if (((Boolean)VulpusConfig.MAKES_PIGLINS_NEUTRAL_VULPUS.get()).booleanValue()) {
                    components.add((Component)Component.translatable((String)"tooltip.immersiveores.immunetopiglin.tooltip").withStyle(ChatFormatting.RED));
                }
                if (((Boolean)VulpusConfig.FIRE_RESISTANCE_VULPUS_ARMOR.get()).booleanValue()) {
                    components.add((Component)Component.translatable((String)"tooltip.immersiveores.playerimmunetofire.tooltip").withStyle(ChatFormatting.RED));
                }
            }
            if (ModItems.VULPUS_LEGGINGS.get() == pStack.getItem()) {
                if (((Boolean)VulpusConfig.UNBREAKABLE_VULPUS.get()).booleanValue()) {
                    components.add((Component)Component.translatable((String)"tooltip.immersiveores.unbreakble.tooltip").withStyle(ChatFormatting.RED));
                }
                components.add((Component)Component.translatable((String)"tooltip.immersiveores.immunetofire.tooltip").withStyle(ChatFormatting.RED));
                if (((Boolean)VulpusConfig.MAKES_PIGLINS_NEUTRAL_VULPUS.get()).booleanValue()) {
                    components.add((Component)Component.translatable((String)"tooltip.immersiveores.immunetopiglin.tooltip").withStyle(ChatFormatting.RED));
                }
                if (((Boolean)VulpusConfig.FIRE_RESISTANCE_VULPUS_ARMOR.get()).booleanValue()) {
                    components.add((Component)Component.translatable((String)"tooltip.immersiveores.playerimmunetofire.tooltip").withStyle(ChatFormatting.RED));
                }
                if (((Boolean)VulpusConfig.NEVER_LOSE_HUNGER_VULPUS_ARMOR.get()).booleanValue()) {
                    components.add((Component)Component.translatable((String)"tooltip.immersiveores.nerverlosehunger.tooltip").withStyle(ChatFormatting.RED));
                }
            }
        } else {
            components.add((Component)Component.translatable((String)"tooltip.immersiveores.pressshiftformoreinfo.tooltip").withStyle(ChatFormatting.RED));
        }
    }

    public boolean makesPiglinsNeutral(ItemStack stack, LivingEntity wearer) {
        return (Boolean)VulpusConfig.CAN_WALK_ON_POWDERED_SNOW_VULPUS.get();
    }

    public boolean canWalkOnPowderedSnow(ItemStack stack, LivingEntity wearer) {
        return (Boolean)VulpusConfig.MAKES_PIGLINS_NEUTRAL_VULPUS.get();
    }
}

