/*
 * Decompiled with CFR 0.152.
 */
package com.blocklegend001.immersiveores.util;

import java.util.function.BiConsumer;
import net.minecraft.client.resources.model.EquipmentClientInfo;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.equipment.EquipmentAsset;

public final class ModEquipmentAssets {
    private static final ResourceKey<? extends Registry<EquipmentAsset>> ROOT_ID = ResourceKey.createRegistryKey((ResourceLocation)ResourceLocation.withDefaultNamespace((String)"equipment_asset"));
    public static final ResourceKey<EquipmentAsset> VIBRANIUM = ModEquipmentAssets.id("vibranium");
    public static final ResourceKey<EquipmentAsset> VULPUS = ModEquipmentAssets.id("vulpus");
    public static final ResourceKey<EquipmentAsset> ENDERIUM = ModEquipmentAssets.id("enderium");

    private static ResourceKey<EquipmentAsset> id(String name) {
        return ResourceKey.create(ROOT_ID, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"immersiveores", (String)name));
    }

    public static void bootstrap(BiConsumer<ResourceKey<EquipmentAsset>, EquipmentClientInfo> consumer) {
        ModEquipmentAssets.registerAssetWithLayers(consumer, VIBRANIUM, "vibranium");
        ModEquipmentAssets.registerAssetWithLayers(consumer, VULPUS, "vulpus");
        ModEquipmentAssets.registerAssetWithLayers(consumer, ENDERIUM, "enderium");
    }

    private static void registerAssetWithLayers(BiConsumer<ResourceKey<EquipmentAsset>, EquipmentClientInfo> consumer, ResourceKey<EquipmentAsset> asset, String name) {
        consumer.accept(asset, EquipmentClientInfo.builder().addHumanoidLayers(ResourceLocation.fromNamespaceAndPath((String)"immersiveores", (String)name)).addLayers(EquipmentClientInfo.LayerType.HORSE_BODY, new EquipmentClientInfo.Layer[]{new EquipmentClientInfo.Layer(ResourceLocation.fromNamespaceAndPath((String)"immersiveores", (String)name))}).build());
    }
}

