package falseresync.lib.blockpattern;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.ints.Int2ObjectRBTreeMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2694;
import net.minecraft.class_4538;

public class BetterBlockPattern {
    protected final Predicate<class_2694>[][][] pattern;
    protected final int width;
    protected final int height;
    protected final int depth;
    protected final int biggestCoordinate;
    protected final int size;
    protected final class_2350[] possibleUp;
    protected final class_2350[] possibleForwards;

    public BetterBlockPattern(Predicate<class_2694>[][][] pattern, boolean preserveUp) {
        this.pattern = pattern;
        width = pattern.length;
        height = pattern[0].length;
        depth = pattern[0][0].length;
        biggestCoordinate = Math.max(Math.max(width, depth), height);
        size = width * height * depth;
        possibleUp = preserveUp ? new class_2350[]{class_2350.field_11036} : class_2350.values();
        possibleForwards = preserveUp
                ? new class_2350[]{class_2350.field_11043, class_2350.field_11034, class_2350.field_11035, class_2350.field_11039}
                : class_2350.values();
    }

    public int getSize() {
        return size;
    }

    public Match searchAround(class_4538 world, class_2338 startingPos) {
        var results = new Int2ObjectRBTreeMap<Match>(Integer::compareTo);
        LoadingCache<class_2338, class_2694> cache = Caffeine.newBuilder()
                .build(pos -> new class_2694(world, pos, false));
        for (var pos : class_2338.method_10097(startingPos, startingPos.method_10069(biggestCoordinate - 1, biggestCoordinate - 1, biggestCoordinate - 1))) {
            for (var forwards : possibleForwards) {
                for (var up : possibleUp) {
                    if (up != forwards && up != forwards.method_10153()) {
                        var result = test(pos, forwards, up, cache);
                        if (result.isCompleted()) {
                            return result;
                        }
                        results.put(result.delta.size(), result);
                    }
                }
            }
        }

        return Objects.requireNonNull(results.firstEntry()).getValue();
    }

    public Match test(class_2338 frontTopLeft, class_2350 forwards, class_2350 up, LoadingCache<class_2338, class_2694> cache) {
        var delta = ImmutableList.<class_2694>builder();

        for (int x = 0; x < width; x++) {
            for (int y = 0; y < height; y++) {
                for (int z = 0; z < depth; z++) {
                    var mew = changeBasis(frontTopLeft, forwards, up, x, y, z);
                    var cachedPos = cache.get(mew);
                    if (!pattern[x][y][z].test(cachedPos)) {
                        delta.add(cachedPos);
                    }
                }
            }
        }

        return new Match(delta.build(), frontTopLeft, forwards, up, width, height, depth, size);
    }

    /**
     * @param origin Front-Top-Left block of the pattern
     */
    // https://stackoverflow.com/q/19621069
    // https://youtu.be/P2LTAUO1TdA
    protected class_2338 changeBasis(class_2338 origin, class_2350 forwards, class_2350 up, int x, int y, int z) {
        Preconditions.checkArgument(up != forwards && up != forwards.method_10153(), "Invalid combination of forwards and up: %s and %s", forwards, up);
        var localOZ = forwards.method_10163();
        var localOY = up.method_10163();
        var localOX = localOY.method_10259(localOZ); // A vector perpendicular to the XZ plane
        return origin.method_10059(new class_2382(
                localOX.method_10263() * x + localOY.method_10263() * y + localOZ.method_10263() * z,
                localOX.method_10264() * x + localOY.method_10264() * y + localOZ.method_10264() * z,
                localOX.method_10260() * x + localOY.method_10260() * y + localOZ.method_10260() * z));
    }

    public record Match(List<class_2694> delta,
                        List<class_2338> deltaAsBlockPos,
                        class_2338 frontTopLeft, class_2350 forwards, class_2350 up,
                        int width, int height, int depth, int size) {
        public Match(List<class_2694> delta,
                     class_2338 frontTopLeft, class_2350 forwards, class_2350 up,
                     int width, int height, int depth, int size) {
            this(delta, delta.stream().map(class_2694::method_11683).toList(), frontTopLeft, forwards, up, width, height, depth, size);
        }

        public boolean isCompleted() {
            return delta.isEmpty();
        }

        public boolean isHalfwayCompleted() {
            return (double) Math.abs(delta.size() - size) / size > 0.5;
        }
    }
}