package falseresync.lib.client;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_757;
import org.joml.Matrix4f;

public class BetterGuiGraphics extends class_332 {
    public BetterGuiGraphics(class_310 client, class_332 context) {
        super(client, context.method_51450());
    }

    public void drawSquare(class_2960 texture, int x, int y, int size) {
        drawSquare(texture, x, y, size, size);
    }

    public void drawSquare(class_2960 texture, int x, int y, int size, int textureSize) {
        drawRect(texture, x, y, size, size, textureSize, textureSize);
    }

    public void drawRect(class_2960 texture, int x, int y, int width, int height) {
        drawRect(texture, x, y, width, height, 16, 16);
    }

    public void drawRect(class_2960 texture, int x, int y, int width, int height, int texWidth, int texHeight) {
        method_25290(texture, x, y, 0, 0, width, height, texWidth, texHeight);
    }

    public void drawTexturedQuad(class_2960 texture, float x1, float x2, float y1, float y2, float u1, float u2, float v1, float v2) {
        float z = 0;
        RenderSystem.setShaderTexture(0, texture);
        RenderSystem.setShader(class_757::method_34542);
        Matrix4f matrix4f = method_51448().method_23760().method_23761();
        class_287 bufferBuilder = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1585);
        bufferBuilder.method_22918(matrix4f, x1, y1, z).method_22913(u1, v1);
        bufferBuilder.method_22918(matrix4f, x1, y2, z).method_22913(u1, v2);
        bufferBuilder.method_22918(matrix4f, x2, y2, z).method_22913(u2, v2);
        bufferBuilder.method_22918(matrix4f, x2, y1, z).method_22913(u2, v1);
        class_286.method_43433(bufferBuilder.method_60800());
    }

    public void drawNonDiscreteRect(class_2960 texture, float x, float y, int u, int v, int regionW, int regionH, int texW, int texH) {
        drawTexturedQuad(texture,
                x + u, x + u + regionW,
                y + v, y + v + regionH,
                (float) u / texW, (float) (u + regionW) / texW,
                (float) v / texH, (float) (v + regionH) / texH);
    }

    public void drawNonDiscreteRect(class_2960 texture, float x, float y, int texW, int texH) {
        drawNonDiscreteRect(texture, x, y, 0, 0, texW, texH, texW, texH);
    }
}
