package falseresync.wizcraft.client;

import dev.emi.trinkets.api.event.TrinketDropCallback;
import dev.emi.trinkets.api.event.TrinketEquipCallback;
import dev.emi.trinkets.api.event.TrinketUnequipCallback;
import falseresync.wizcraft.client.hud.ChargeDisplayHudItem;
import falseresync.wizcraft.client.hud.FocusPickerHudItem;
import falseresync.wizcraft.common.data.WizcraftAttachments;
import falseresync.wizcraft.common.data.WizcraftComponents;
import falseresync.wizcraft.common.item.WizcraftItemTags;
import falseresync.wizcraft.common.item.WizcraftItems;
import falseresync.wizcraft.networking.c2s.ChangeWandFocusC2SPayload;
import falseresync.wizcraft.networking.c2s.WandFocusDestination;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_746;
import javax.annotation.Nullable;

import java.util.LinkedList;
import java.util.stream.Collectors;

public class ToolManager {
    private final ChargeDisplayHudItem chargeDisplay;
    private final FocusPickerHudItem focusPicker;

    public ToolManager() {
        chargeDisplay = WizcraftClient.getHud().getChargeDisplay();
        focusPicker = WizcraftClient.getHud().getFocusPicker();

        TrinketEquipCallback.EVENT.register((stack, slot, entity) -> {
            if (entity instanceof class_1657 player) {
                var wandStack = scanInventoryForWands(player.method_31548());
                if (wandStack != null) {
                    setupChargeDisplay(player, wandStack);
                }
            }
        });

        TrinketDropCallback.EVENT.register((rule, stack, ref, entity) -> {
            if (entity instanceof class_1657 player) {
                hideChargeDisplayIfShould(player);
            }
            return rule;
        });

        TrinketUnequipCallback.EVENT.register((stack, slot, entity) -> {
            if (entity instanceof class_1657 player) {
                hideChargeDisplayIfShould(player);
            }
        });

        ClientInventoryEvents.SELECTED_SLOT_CHANGED.register((inventory, lastSelectedSlot) -> {
            var wandStack = scanInventoryForWands(inventory);
            if (wandStack != null) {
                setupChargeDisplay(inventory.field_7546, wandStack);
            } else {
                chargeDisplay.hide();
                focusPicker.hide();
            }
        });

        ClientInventoryEvents.CONTENTS_CHANGED.register(inventory -> {
            var wandStack = scanInventoryForWands(inventory);
            if (wandStack != null) {
                setupChargeDisplay(inventory.field_7546, wandStack);
                scanInventoryAndSetupFocusPicker(inventory, wandStack, false);
            } else {
                chargeDisplay.hide();
                focusPicker.hide();
            }
        });
    }

    public void onKeyPressed(class_310 client, class_746 player) {
        var wandStack = scanInventoryForWands(player.method_31548());
        if (wandStack == null) {
            focusPicker.hide();
            return;
        }
        scanInventoryAndSetupFocusPicker(player.method_31548(), wandStack, true);
    }

    @Nullable
    private class_1799 scanInventoryForWands(class_1661 inventory) {
        var wandStack = inventory.method_7391();
        return wandStack.method_31573(WizcraftItemTags.WANDS) ? wandStack : null;
    }

    private void setupChargeDisplay(class_1657 player, class_1799 wandStack) {
        if (player.hasAttached(WizcraftAttachments.HAS_TRUESEER_GOGGLES)) {
            chargeDisplay.upload(wandStack);
            chargeDisplay.show();
        }
    }

    private void hideChargeDisplayIfShould(class_1657 player) {
        if (chargeDisplay.isVisible() && !player.hasAttached(WizcraftAttachments.HAS_TRUESEER_GOGGLES)) {
            chargeDisplay.hide();
        }
    }

    private void scanInventoryAndSetupFocusPicker(class_1661 inventory, class_1799 wandStack, boolean shouldPickNext) {
        var equipped = wandStack.method_57825(WizcraftComponents.EQUIPPED_FOCUS_ITEM, class_1799.field_8037);
        var belt = WizcraftItems.FOCUSES_BELT.findTrinketStack(inventory.field_7546);
        var focusStacks = belt
                .map(it -> WizcraftItems.FOCUSES_BELT.getOrCreateInventoryComponent(it).stacks().stream().filter(stack -> !stack.method_7960()))
                .orElseGet(() -> inventory.field_7547.stream().filter(it -> it.method_31573(WizcraftItemTags.FOCUSES)))
                .collect(Collectors.toCollection(LinkedList::new));

        if (!equipped.method_7960()) {
            focusStacks.addFirst(equipped);
        }

        if (focusStacks.isEmpty()) {
            class_310.method_1551().field_1705.method_1758(class_2561.method_43471("hud.wizcraft.wand.no_focuses"), false);
            return;
        }

        var picked = setupFocusPicker(wandStack, focusStacks, equipped, shouldPickNext);
        if (picked != null) {
            if (belt.isPresent()) {
                var slot = belt
                        .map(WizcraftItems.FOCUSES_BELT::getOrCreateInventoryComponent)
                        .map(component -> component.getSlotWithStack(picked))
                        .orElse(-1);
                ClientPlayNetworking.send(new ChangeWandFocusC2SPayload(WandFocusDestination.FOCUSES_BELT, slot));
            } else {
                var slot = inventory.method_7395(picked);
                ClientPlayNetworking.send(new ChangeWandFocusC2SPayload(WandFocusDestination.PLAYER_INVENTORY, slot));
            }
        }
    }

    @Nullable
    private class_1799 setupFocusPicker(class_1799 wandStack, LinkedList<class_1799> focusStacks, class_1799 equipped, boolean shouldPickNext) {
        focusPicker.upload(wandStack, focusStacks);

        if (shouldPickNext) {
            // First press opens the menu, following ones change the focus
            // But if there was no focus equipped, pick on first press anyway
            if (focusPicker.isVisible() || equipped.method_7960()) {
                focusPicker.pickNext();
            }
            focusPicker.show();

            var picked = focusPicker.getCurrentlyPicked();
            return class_1799.method_31577(equipped, picked) ? null : picked;
        }

        return null;
    }
}
