package falseresync.wizcraft.client.gui;

import falseresync.wizcraft.common.data.ContainerComponent;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5684;

public class ContainerComponentTooltip implements class_5684 {
    private static final class_2960 BACKGROUND_TEXTURE = class_2960.method_60656("container/bundle/background");
    private static final int BOTTOM_MARGIN = 4;
    private static final int WIDTH_PER_COLUMN = 18;
    private static final int HEIGHT_PER_ROW = 20;
    private final ContainerComponent containerComponent;

    public ContainerComponentTooltip(ContainerComponent containerComponent) {
        this.containerComponent = containerComponent;
    }

    @Override
    public int method_32661() {
        return getRowsHeight() + BOTTOM_MARGIN;
    }

    @Override
    public int method_32664(class_327 textRenderer) {
        return getColumnsWidth();
    }

    private int getColumnsWidth() {
        return getColumns() * WIDTH_PER_COLUMN + 2;
    }

    private int getRowsHeight() {
        return getRows() * HEIGHT_PER_ROW + 2;
    }

    @Override
    public void method_32666(class_327 textRenderer, int x, int y, class_332 context) {
        int columns = getColumns();
        int rows = getRows();
        context.method_52706(BACKGROUND_TEXTURE, x, y, this.getColumnsWidth(), this.getRowsHeight());

        int slotIndex = 0;
        for (int row = 0; row < rows; row++) {
            for (int column = 0; column < columns; column++) {
                int slotX = x + column * 18 + 1;
                int slotY = y + row * 20 + 1;
                drawSlot(slotX, slotY, slotIndex++, context, textRenderer);
            }
        }
    }

    private void drawSlot(int x, int y, int index, class_332 context, class_327 textRenderer) {
        if (index >= containerComponent.size()) {
            drawSprite(context, x, y, SlotSprite.SLOT);
        } else {
            class_1799 itemStack = containerComponent.stacks().get(index);
            drawSprite(context, x, y, SlotSprite.SLOT);
            context.method_51428(itemStack, x + 1, y + 1, index);
            context.method_51431(textRenderer, itemStack, x + 1, y + 1);
        }
    }

    private void drawSprite(class_332 context, int x, int y, SlotSprite sprite) {
        context.method_52707(sprite.texture, x, y, 0, sprite.width, sprite.height);
    }

    private int getColumns() {
        return Math.max(2, (int) Math.ceil(Math.sqrt((double) containerComponent.size() + 1.0)));
    }

    private int getRows() {
        return (int) Math.ceil((double) containerComponent.size() / (double) getColumns());
    }

    enum SlotSprite {
        SLOT(class_2960.method_60656("container/bundle/slot"), 18, 20);

        public final class_2960 texture;
        public final int width;
        public final int height;

        SlotSprite(final class_2960 texture, final int width, final int height) {
            this.texture = texture;
            this.width = width;
            this.height = height;
        }
    }
}
