package falseresync.wizcraft.client.hud;

import com.mojang.blaze3d.systems.RenderSystem;
import falseresync.lib.client.BetterGuiGraphics;
import falseresync.lib.math.Easing;
import falseresync.wizcraft.client.WizcraftClient;
import falseresync.wizcraft.common.data.WizcraftComponents;
import falseresync.wizcraft.common.item.focus.FocusItem;
import org.joml.Matrix4f;

import java.util.Comparator;
import java.util.LinkedList;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_9334;
import net.minecraft.class_9779;

import static falseresync.wizcraft.common.Wizcraft.wid;

public class FocusPickerHudItem implements HudItem {
    protected static final class_2960 SELECTION_TEX = wid("textures/hud/wand/focus_picker_selection.png");
    private static final int MARGIN = 2;
    private static final int WIDGET_W = 22;
    private static final int WIDGET_H = 22;
    private static final int TEX_SIZE = 22;
    private static final int ITEM_W = 16;
    private static final int ITEM_H = 16;
    private static final int TEXT_H = 8;
    private static final int DISPLAY_DURATION = 60;
    private static final int PARENT_ANIMATION_DURATION = 8;
    private static final int ITEMS_ANIMATION_DURATION = 6;
    // Order focuses by registry order, and then their variants first by plating, then by UUID to allow for the highest flexibility
    private static final Comparator<class_1799> FOCUS_ORDERING = Comparator
            .<class_1799>comparingInt(stack -> ((FocusItem) stack.method_7909()).getRawId())
            .thenComparingInt(stack -> stack.method_57825(WizcraftComponents.FOCUS_PLATING, -1))
            .thenComparingLong(stack -> stack.method_57825(WizcraftComponents.UUID, UUID.randomUUID()).getMostSignificantBits());
    private final class_310 client;
    private final class_327 textRenderer;
    private final LinkedList<class_1799> focuses = new LinkedList<>();
    private class_1799 wand;
    private float baseOpacity = 1;
    private boolean isVisible = false;
    private int remainingDisplayTicks = 0;
    private boolean animatingParent = false;
    private int remainingParentAnimationTicks = 0;
    private boolean animatingItems = false;
    private int remainingItemsAnimationTicks = 0;

    public FocusPickerHudItem(class_310 client, class_327 textRenderer) {
        this.client = client;
        this.textRenderer = textRenderer;
    }

    @Override
    public void render(BetterGuiGraphics context, class_9779 tickCounter) {
        if (isVisible() || animatingParent) {
            baseOpacity = getAnimatedBaseOpacity();
            var yOffsetPerItem = ITEM_H + MARGIN;
            var yOffset = (Math.min(focuses.size(), 3) - 1) * yOffsetPerItem;
            var widgetH = WIDGET_H + yOffset;

            var chargeDisplay = WizcraftClient.getHud().getChargeDisplay();
            var x = 4 + (chargeDisplay.isVisible() ? chargeDisplay.getWidth() : 0);
            var y = context.method_51443() / 2 - widgetH / 2;

            RenderSystem.enableBlend();
            context.method_51422(1, 1, 1, baseOpacity);

            context.drawSquare(SELECTION_TEX, x, y + yOffset, 22, TEX_SIZE);

            var itemX = x + WIDGET_W / 2 - ITEM_W / 2;

            if (animatingItems) {
                var item1 = addGlintIfNecessary(focuses.peekLast());
                int item1Y = y + WIDGET_H / 2 - ITEM_H / 2 + yOffset;
                float item1Scale = (float) Easing.easeOutCirc((double) (remainingItemsAnimationTicks) / ITEMS_ANIMATION_DURATION);
                float item1Translation = (float) (WIDGET_H * Easing.easeInSine((double) (ITEMS_ANIMATION_DURATION - remainingItemsAnimationTicks) / ITEMS_ANIMATION_DURATION));
                float item1Opacity = baseOpacity * remainingItemsAnimationTicks / ITEMS_ANIMATION_DURATION;
                paintItem(context, item1, itemX, item1Y, item1Scale, item1Translation, item1Opacity, false);

                if (focuses.size() > 1) {
                    var item2 = addGlintIfNecessary(focuses.getFirst());
                    int item2Y = y + Math.min(focuses.size() - 2, 1) * yOffsetPerItem + yOffsetPerItem / 2 - ITEM_H / 2;
                    float item2Scale = 0.85f + (1 - 0.85f) * (float) Easing.easeOutSine((double) (ITEMS_ANIMATION_DURATION - remainingItemsAnimationTicks) / ITEMS_ANIMATION_DURATION);
                    float item2Translation = (float) (yOffsetPerItem * Easing.easeInOutSine((double) (ITEMS_ANIMATION_DURATION - remainingItemsAnimationTicks) / ITEMS_ANIMATION_DURATION));
                    paintItem(context, item2, itemX, item2Y, item2Scale, item2Translation, baseOpacity, false);
                }

                if (focuses.size() > 2) {
                    var item3 = focuses.get(1);
                    int item3Y = y + yOffsetPerItem / 2 - ITEM_H / 2;
                    float item3Scale = 0.70f * (float) Easing.easeOutSine((double) (ITEMS_ANIMATION_DURATION - remainingItemsAnimationTicks) / ITEMS_ANIMATION_DURATION);
                    float item3Translation = (float) (yOffsetPerItem * Easing.easeInOutSine((double) (ITEMS_ANIMATION_DURATION - remainingItemsAnimationTicks) / ITEMS_ANIMATION_DURATION));
                    paintItem(context, item3, itemX, item3Y, item3Scale, item3Translation, baseOpacity, false);

                    var item4 = focuses.get(2);
                    int item4Y = y + yOffsetPerItem / 2 - ITEM_H / 2;
                    float item4Scale = 0.70f * (float) Easing.easeInOutQuad((double) (ITEMS_ANIMATION_DURATION - remainingItemsAnimationTicks) / ITEMS_ANIMATION_DURATION);
                    paintItem(context, item4, itemX, item4Y, item4Scale, 0f, baseOpacity / 2, true);
                }
            } else {
                var item1 = addGlintIfNecessary(focuses.getFirst());
                var item1Y = y + WIDGET_H / 2 - ITEM_H / 2 + yOffset;
                paintItem(context, item1, itemX, item1Y, 1f, 0f, baseOpacity, false);

                if (focuses.size() > 1) {
                    var item2 = focuses.get(1);
                    var item2Y = y + Math.min(focuses.size() - 2, 1) * yOffsetPerItem + yOffsetPerItem / 2 - ITEM_H / 2;
                    paintItem(context, item2, itemX, item2Y, 0.85f, 0f, baseOpacity, false);
                }

                if (focuses.size() > 2) {
                    var item3 = focuses.get(2);
                    var item3Y = y + yOffsetPerItem / 2 - ITEM_H / 2;
                    paintItem(context, item3, itemX, item3Y, 0.70f, 0f, baseOpacity, true);
                }
            }

            RenderSystem.disableBlend();
        }
    }

    protected class_1799 addGlintIfNecessary(class_1799 stack) {
        class_1799 stackWithGlint = null;
        if (wand.method_7958() && stack != null) {
            stackWithGlint = stack.method_7972();
            stackWithGlint.method_57379(class_9334.field_49641, true);
        }
        return stackWithGlint == null ? stack : stackWithGlint;
    }

    protected void paintItem(BetterGuiGraphics context, class_1799 stack, int x, int y, float scale, float translation, float opacity, boolean shouldTint) {
        var poseStack = context.method_51448();
        poseStack.method_22903();
        poseStack.method_34425(new Matrix4f().scaleAround(scale, scale, 1f, x + ITEM_W / 2f, y + ITEM_H / 2f, 0));
        poseStack.method_46416(0, translation, 0);
        if (shouldTint) {
            context.method_51422(161 / 255f, 158 / 255f, 170 / 255f, opacity);
        } else {
            context.method_51422(1, 1, 1, opacity);
        }

        context.method_51445(stack, x, y);
        context.method_51431(textRenderer, stack, x, y);

        context.method_51422(1, 1, 1, baseOpacity);
        poseStack.method_22909();
    }

    private float getAnimatedBaseOpacity() {
        if (animatingParent) {
            return isVisible()
                    ? 1 - (float) remainingParentAnimationTicks / PARENT_ANIMATION_DURATION
                    : (float) remainingParentAnimationTicks / PARENT_ANIMATION_DURATION;
        }
        return 1;
    }

    @Override
    public void tick() {
        if (client.field_1724 == null) {
            clear();
            return;
        }

        if (remainingDisplayTicks > 0) {
            remainingDisplayTicks -= 1;

            if (remainingDisplayTicks == 0) {
                hide();
            }
        }

        if (remainingParentAnimationTicks > 0) {
            remainingParentAnimationTicks -= 1;

            if (remainingParentAnimationTicks == 0) {
                animatingParent = false;

                if (remainingDisplayTicks == 0) {
                    clear();
                }
            }
        }

        if (remainingItemsAnimationTicks > 0) {
            remainingItemsAnimationTicks -= 1;

            if (remainingItemsAnimationTicks == 0) {
                animatingItems = false;
            }
        }
    }

    public void show() {
        if (!isVisible()) {
            animateParent();
        }
        isVisible = true;
        remainingDisplayTicks = DISPLAY_DURATION;
    }

    public void hide() {
        if (isVisible()) {
            animateParent();
        }
        isVisible = false;
    }

    private void clear() {
        isVisible = false;
        wand = null;
        focuses.clear();
    }

    private void animateParent() {
        animatingParent = true;
        remainingParentAnimationTicks = PARENT_ANIMATION_DURATION;
    }

    private void animateItems() {
        animatingItems = true;
        remainingItemsAnimationTicks = ITEMS_ANIMATION_DURATION;
    }

    /**
     * @param wand has to be the same stack, not a copy
     */
    public void upload(class_1799 wand, LinkedList<class_1799> newFocuses) {
        this.wand = wand;

        focuses.clear();
        focuses.addAll(newFocuses);
        focuses.sort(FOCUS_ORDERING);
        // Scroll to the currently picked focus
        while (!Objects.equals(
                newFocuses.getFirst().method_57824(WizcraftComponents.UUID),
                focuses.getFirst().method_57824(WizcraftComponents.UUID))
        ) {
            focuses.addLast(focuses.removeFirst());
        }
        getCurrentlyPicked();
    }

    public void pickNext() {
        if (focuses.size() > 1) {
            focuses.addLast(focuses.removeFirst());
            animateItems();
        }
    }

    public class_1799 getCurrentlyPicked() {
        return focuses.getFirst();
    }

    public boolean isVisible() {
        return isVisible && !focuses.isEmpty() && wand != null;
    }
}