package falseresync.wizcraft.client.hud;

import falseresync.lib.client.BetterGuiGraphics;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_310;

@Environment(EnvType.CLIENT)
public class WizcraftHud {
    private final class_310 client;
    private final FocusPickerHudItem focusPicker;
    private final ChargeDisplayHudItem chargeDisplay;

    public WizcraftHud(class_310 minecraft) {
        this.client = minecraft;
        focusPicker = new FocusPickerHudItem(minecraft, minecraft.field_1772);
        chargeDisplay = new ChargeDisplayHudItem(minecraft, minecraft.field_1772);
        initEventListeners();
    }

    private void initEventListeners() {
        HudRenderCallback.EVENT.register((vanillaContext, tickCounter) -> {
            var context = new BetterGuiGraphics(client, vanillaContext);
            focusPicker.render(context, tickCounter);
            chargeDisplay.render(context, tickCounter);
        });

        ClientTickEvents.START_WORLD_TICK.register(world -> {
            if (client.method_1493()) return;

            focusPicker.tick();
            chargeDisplay.tick();
        });
    }

    public FocusPickerHudItem getFocusPicker() {
        return focusPicker;
    }

    public ChargeDisplayHudItem getChargeDisplay() {
        return chargeDisplay;
    }
}