package falseresync.wizcraft.client.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import falseresync.wizcraft.client.render.item.ChargingFocusUseAction;
import falseresync.wizcraft.common.item.WizcraftItems;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_572;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(class_572.class)
public class HumanoidModelMixin {
    @WrapOperation(
            method = "setupAnim(Lnet/minecraft/world/entity/LivingEntity;FFFFF)V",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/client/model/HumanoidModel;poseRightArm(Lnet/minecraft/world/entity/LivingEntity;)V"))
    public void wizcraft$positionRightArm(class_572<class_1309> instance,
                                          class_1309 entity,
                                          Operation<Void> original,
                                          @Local(argsOnly = true, ordinal = 0) float limbAngle,
                                          @Local(argsOnly = true, ordinal = 1) float limbDistance,
                                          @Local(argsOnly = true, ordinal = 2) float animationProgress,
                                          @Local(argsOnly = true, ordinal = 3) float headYaw,
                                          @Local(argsOnly = true, ordinal = 4) float headPitch) {
        if (entity.method_6115()) {
            var context = new ChargingFocusUseAction.BipedEntityModelContext(
                    instance, entity, class_1306.field_6183, limbAngle, limbDistance, animationProgress, headYaw, headPitch
            );

            if (!ChargingFocusUseAction.shouldSkipDefaultArmPositioning(context)) {
                original.call(instance, entity);
            }

            var stack = entity.method_6047();
            if (stack.method_31574(WizcraftItems.WAND) && WizcraftItems.WAND.getEquipped(stack).method_31574(WizcraftItems.CHARGING_FOCUS)) {
                ChargingFocusUseAction.positionArm(context);
            }
        } else {
            original.call(instance, entity);
        }
    }
}
