package falseresync.wizcraft.client.render;

import falseresync.lib.math.Color;
import falseresync.wizcraft.common.Wizcraft;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandlerRegistry;
import net.minecraft.class_1058;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_761;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_918;
import javax.annotation.Nullable;

import java.util.Objects;

public class RenderingUtil {
    public static final class_243 UNIT_VEC3D = RenderingUtil.getSymmetricVec3d(1);

    public static class_243 getSymmetricVec3d(double value) {
        return new class_243(value, value, value);
    }

    public static void levitateItemAboveBlock(class_1937 world, class_2338 pos, float partialTick, class_1799 stack, class_918 itemRenderer, class_4587 poseStack, class_4597 bufferSource) {
        levitateItemAboveBlock(world, pos, class_243.field_1353, RenderingUtil.UNIT_VEC3D, partialTick, stack, itemRenderer, poseStack, bufferSource);
    }

    public static void levitateItemAboveBlock(class_1937 world, class_2338 pos, float partialTick, class_1799 stack, class_811 mode, class_918 itemRenderer, class_4587 poseStack, class_4597 bufferSource) {
        levitateItemAboveBlock(world, pos, class_243.field_1353, RenderingUtil.UNIT_VEC3D, partialTick, stack, mode, itemRenderer, poseStack, bufferSource);
    }

    public static void levitateItemAboveBlock(class_1937 world, class_2338 pos, class_243 translation, class_243 scale, float partialTick, class_1799 stack, class_918 itemRenderer, class_4587 poseStack, class_4597 bufferSource) {
        levitateItemAboveBlock(world, pos, translation, scale, partialTick, stack, class_811.field_4319, itemRenderer, poseStack, bufferSource);
    }

    public static void levitateItemAboveBlock(class_1937 world, class_2338 pos, class_243 translation, class_243 scale, float partialTick, class_1799 stack, class_811 mode, class_918 itemRenderer, class_4587 poseStack, class_4597 bufferSource) {
        if (stack.method_7960()) return;

        switch (Wizcraft.getConfig().animationQuality) {
            case DEFAULT -> {
                poseStack.method_22903();

                var offset = class_3532.method_15374((world.method_8510() + partialTick) / 16) / 16;
                poseStack.method_22904(0.5 + translation.field_1352, 1.25 + offset + translation.field_1351, 0.5 + translation.field_1350);
                poseStack.method_22907(class_7833.field_40716.rotationDegrees(world.method_8510() + partialTick));

                scale = scale.method_1021(stack.method_7909() instanceof class_1747 ? 0.75 : 0.5);
                poseStack.method_22905((float) scale.field_1352, (float) scale.field_1351, (float) scale.field_1350);

                var lightAbove = class_761.method_23794(world, pos.method_10084());
                itemRenderer.method_23178(stack, mode, lightAbove, class_4608.field_21444, poseStack, bufferSource, world, 0);

                poseStack.method_22909();
            }
            case FAST -> {
                poseStack.method_22903();
                var lightAbove = class_761.method_23794(world, pos.method_10084());
                itemRenderer.method_23178(stack, mode, lightAbove, class_4608.field_21444, poseStack, bufferSource, world, 0);
                poseStack.method_22909();
            }
        }
    }

    public static void addParticle(class_1937 world, @Nullable class_2394 parameters, class_243 position, class_243 velocity) {
        if (parameters != null) {
            world.method_8406(parameters, position.field_1352, position.field_1351, position.field_1350, velocity.field_1352, velocity.field_1351, velocity.field_1350);
        }
    }

    public static void drawFluid(class_4587 poseStack, class_4588 buffer, class_1920 view, class_2338 pos, class_3611 fluid, class_3610 state, boolean still, int light, int overlay, float x, float width, float y, float height, float depth) {
        var handler = Objects.requireNonNull(FluidRenderHandlerRegistry.INSTANCE.get(fluid));
        var sprites = handler.getFluidSprites(view, pos, state);
        var tint = handler.getFluidColor(view, pos, state);
        drawTexturedSprite(poseStack, buffer, still ? sprites[0] : sprites[1], Color.ofRgb(tint).argb(), light, overlay, x, width, y, height, depth);
    }

    /**
     * Use when RenderLayer requires a texture input (e.g. entity_* ones)
     */
    public static void drawSprite(class_4587 poseStack, class_4588 buffer, class_1058 sprite, int tint, int light, int overlay, float x, float width, float y, float height, float depth) {
        drawTexture(poseStack, buffer, tint, light, overlay, x, x + width, y, y + height, depth, sprite.method_4594(), sprite.method_4577(), sprite.method_4593(), sprite.method_4575());
    }

    /**
     * Use when RenderLayer doesn't require a texture input (e.g. cutout or translucent)
     */
    public static void drawTexturedSprite(class_4587 poseStack, class_4588 buffer, class_1058 sprite, int tint, int light, int overlay, float x, float width, float y, float height, float depth) {
        drawTexture(poseStack, sprite.method_24108(buffer), tint, light, overlay, x, x + width, y, y + height, depth, sprite.method_4594(), sprite.method_4577(), sprite.method_4593(), sprite.method_4575());
    }

    public static void drawTexture(class_4587 poseStack, class_4588 buffer, int tint, int light, int overlay, float x, float width, float y, float height, float depth) {
        drawTexture(poseStack, buffer, tint, light, overlay, x, x + width, y, y + height, depth, 0, 1, 0, 1);
    }

    public static void drawTexture(class_4587 poseStack, class_4588 buffer, int tint, int light, int overlay, float x1, float x2, float y1, float y2, float z, float u1, float u2, float v1, float v2) {
        var positionMatrix = poseStack.method_23760().method_23761();
        buffer.method_22918(positionMatrix, x1, y1, z).method_22913(u1, v1).method_39415(tint).method_22922(overlay).method_60803(light).method_22914(0, 1, 0);
        buffer.method_22918(positionMatrix, x1, y2, z).method_22913(u1, v2).method_39415(tint).method_22922(overlay).method_60803(light).method_22914(0, 1, 0);
        buffer.method_22918(positionMatrix, x2, y2, z).method_22913(u2, v2).method_39415(tint).method_22922(overlay).method_60803(light).method_22914(0, 1, 0);
        buffer.method_22918(positionMatrix, x2, y1, z).method_22913(u2, v1).method_39415(tint).method_22922(overlay).method_60803(light).method_22914(0, 1, 0);
    }
}
