package falseresync.wizcraft.client.render;

import dev.emi.trinkets.api.client.TrinketRendererRegistry;
import falseresync.wizcraft.client.render.blockentity.ChargingWorktableRenderer;
import falseresync.wizcraft.client.render.blockentity.CraftingWorktableRenderer;
import falseresync.wizcraft.client.render.blockentity.CrucibleRenderer;
import falseresync.wizcraft.client.render.blockentity.LensRenderer;
import falseresync.wizcraft.client.render.blockentity.LensingPedestalRenderer;
import falseresync.wizcraft.client.render.entity.EnergyVeilFeatureRenderer;
import falseresync.wizcraft.client.render.entity.EnergyVeilModel;
import falseresync.wizcraft.client.render.entity.StarProjectileRenderer;
import falseresync.wizcraft.client.render.trinket.TrueseerGogglesRenderer;
import falseresync.wizcraft.client.render.world.CometWarpBeaconRenderer;
import falseresync.wizcraft.common.block.WizcraftBlocks;
import falseresync.wizcraft.common.blockentity.WizcraftBlockEntities;
import falseresync.wizcraft.common.data.WizcraftComponents;
import falseresync.wizcraft.common.entity.WizcraftEntities;
import falseresync.wizcraft.common.item.WizcraftItems;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.client.rendering.v1.BuiltinItemRendererRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.EntityModelLayerRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.EntityRendererRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_1921;
import net.minecraft.class_5272;
import net.minecraft.class_5616;
import net.minecraft.class_6344;

import static falseresync.wizcraft.common.Wizcraft.wid;

public class WizcraftRendering {
    public static void init() {
        EntityModelLayerRegistry.registerModelLayer(LensRenderer.LAYER, LensRenderer::getTexturedModelData);
        EntityModelLayerRegistry.registerModelLayer(EnergyVeilFeatureRenderer.LAYER, EnergyVeilModel::getTexturedModelData);

        EntityRendererRegistry.register(WizcraftEntities.STAR_PROJECTILE, StarProjectileRenderer::new);
        EntityRendererRegistry.register(WizcraftEntities.ENERGY_VEIL, class_6344::new);

        class_5616.method_32144(WizcraftBlockEntities.LENS, LensRenderer::new);
        class_5616.method_32144(WizcraftBlockEntities.CRAFTING_WORKTABLE, CraftingWorktableRenderer::new);
        class_5616.method_32144(WizcraftBlockEntities.CHARGING_WORKTABLE, ChargingWorktableRenderer::new);
        class_5616.method_32144(WizcraftBlockEntities.LENSING_PEDESTAL, LensingPedestalRenderer::new);
        class_5616.method_32144(WizcraftBlockEntities.CRUCIBLE, CrucibleRenderer::new);

        BlockRenderLayerMap.INSTANCE.putBlocks(
                class_1921.method_23581(),
                WizcraftBlocks.CRUCIBLE,
                WizcraftBlocks.LENSING_PEDESTAL,
                WizcraftBlocks.DUMMY_WORKTABLE,
                WizcraftBlocks.CRAFTING_WORKTABLE,
                WizcraftBlocks.CHARGING_WORKTABLE);
        BlockRenderLayerMap.INSTANCE.putBlocks(
                class_1921.method_23583(),
                WizcraftBlocks.LENS);

        BuiltinItemRendererRegistry.INSTANCE.register(WizcraftItems.LENS, new LensRenderer.ItemRenderer());

        class_5272.field_24443.put(wid("focus_plating"), (stack, world, entity, seed) -> stack.method_57825(WizcraftComponents.FOCUS_PLATING, -1));

        TrinketRendererRegistry.registerRenderer(WizcraftItems.TRUESEER_GOGGLES, new TrueseerGogglesRenderer());

        var cometWarpBeaconRenderer = new CometWarpBeaconRenderer();
        WorldRenderEvents.AFTER_ENTITIES.register(cometWarpBeaconRenderer);
        WorldRenderEvents.END.register(cometWarpBeaconRenderer);
//        LivingEntityFeatureRendererRegistrationCallback.EVENT.register();
    }
}
