package falseresync.wizcraft.client.render.blockentity;

import falseresync.wizcraft.client.render.RenderingUtil;
import falseresync.wizcraft.common.Wizcraft;
import falseresync.wizcraft.common.WizcraftParticleTypes;
import falseresync.wizcraft.common.blockentity.ChargingWorktableBlockEntity;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_811;
import net.minecraft.class_827;
import net.minecraft.class_918;

@Environment(EnvType.CLIENT)
public class ChargingWorktableRenderer implements class_827<ChargingWorktableBlockEntity> {
    protected final class_918 itemRenderer;

    public ChargingWorktableRenderer(class_5614.class_5615 ctx) {
        this.itemRenderer = ctx.method_43335();
    }

    @Override
    public void render(ChargingWorktableBlockEntity entity, float partialTick, class_4587 poseStack, class_4597 bufferSource, int packedLight, int packedOverlay) {
        var world = entity.method_10997();
        var stack = entity.getHeldStackCopy();
        if (stack.method_7960() || world == null) return;

        poseStack.method_22903();

        RenderingUtil.levitateItemAboveBlock(
                world, entity.method_11016(), partialTick, stack,
                entity.isCharging() ? class_811.field_4320 : class_811.field_4319,
                this.itemRenderer, poseStack, bufferSource);

        if (entity.isCharging() && world.field_9229.method_43057() < Wizcraft.getConfig().animationParticlesAmount.modifier) {
            var itemPos = entity.method_11016().method_46558().method_1031(0, -0.5, 0);
            var particlePos = itemPos.method_1031(world.field_9229.method_43057() - 0.5, 2, world.field_9229.method_43057() - 0.5);
            var particleVelocity = particlePos.method_1035(itemPos).method_1021(5);
            RenderingUtil.addParticle(world, WizcraftParticleTypes.CHARGING, particlePos, particleVelocity);
        }

        poseStack.method_22909();
    }
}
