package falseresync.wizcraft.client.render.blockentity;

import falseresync.wizcraft.client.render.RenderingUtil;
import falseresync.wizcraft.common.Wizcraft;
import falseresync.wizcraft.common.WizcraftParticleTypes;
import falseresync.wizcraft.common.blockentity.CraftingWorktableBlockEntity;
import falseresync.wizcraft.common.blockentity.LensingPedestalBlockEntity;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_5819;
import net.minecraft.class_827;
import net.minecraft.class_918;
import javax.annotation.Nullable;

import java.util.List;
import java.util.stream.Stream;

import static falseresync.wizcraft.client.render.RenderingUtil.getSymmetricVec3d;

@Environment(EnvType.CLIENT)
public class CraftingWorktableRenderer implements class_827<CraftingWorktableBlockEntity> {
    protected final class_918 itemRenderer;

    public CraftingWorktableRenderer(class_5614.class_5615 ctx) {
        this.itemRenderer = ctx.method_43335();
    }

    protected static void animateCraftingProgress(RenderingData worktable, CraftingWorktableBlockEntity.Progress progress, List<RenderingData> pedestals, class_1937 level, class_918 itemRenderer, float partialTick, class_4587 poseStack, class_4597 bufferSource) {
        var random = level.method_8409();

        // Stop early because particles live some time
        if (progress.remainingCraftingTime() > 10) {
            for (var pedestal : pedestals) {
                addParticleBeam(worktable, progress, pedestal, level, partialTick);
            }
        }

        // Stop early and start a bit later to create an effect that particles start to swirl
        if (progress.remainingCraftingTime() > 10 && progress.passedCraftingTime() > 5) {
            for (var pedestal : pedestals) {
                addParticleHurricane(worktable, progress, pedestal, level, partialTick);
            }
        }

        // Disintegrate the pedestal items
        for (var pedestal : pedestals) {
            addDisintegrationParticles(level, random, pedestal, progress);
        }

        // Disintegrate the worktable item near the end as well
        if (progress.remainingCraftingTime() < 40) {
            addDisintegrationParticles(level, random, worktable, progress);

            // Increase amount of worktable item disintegration particles
            if (progress.remainingCraftingTime() < 10) {
                addDisintegrationParticles(level, random, worktable, progress);
            }
        }

        // Render items until the very end (they'll be too small then anyway
        if (progress.remainingCraftingTime() > 5) {
            levitateItems(worktable, progress.value(), pedestals, level, itemRenderer, partialTick, poseStack, bufferSource);
        }

        // Start to render the resulting item
        if (progress.remainingCraftingTime() < 30 && !progress.currentlyCrafted().method_7960()) {
            var scale = getSymmetricVec3d(getCraftingResultScaleForProgress(progress.value()));
            RenderingUtil.levitateItemAboveBlock(level, worktable.pos, class_243.field_1353, scale, partialTick, progress.currentlyCrafted(), itemRenderer, poseStack, bufferSource);
        }
    }

    protected static double getCraftingResultScaleForProgress(double p) {
        return -1 / (19 * p - 20);
    }

    protected static void levitateItems(RenderingData worktable, float craftingProgress, List<RenderingData> pedestals, class_1937 level, class_918 itemRenderer, float partialTick, class_4587 poseStack, class_4597 bufferSource) {
        var scale = getSymmetricVec3d(1 - craftingProgress);
        RenderingUtil.levitateItemAboveBlock(level, worktable.pos, class_243.field_1353, scale, partialTick, worktable.stack, itemRenderer, poseStack, bufferSource);

        for (var pedestal : pedestals) {
            var translation = worktable.above.method_1035(pedestal.above);
            RenderingUtil.levitateItemAboveBlock(level, pedestal.pos, translation, scale, partialTick, pedestal.stack, itemRenderer, poseStack, bufferSource);
        }
    }

    // ALL, and I mean - ALL parenthesis matter here
    protected static double getVelocityForProgress(double p) {
        return 0.2 * (-0.4 - 1.05 / (1 * (1.1 * Math.log10(-2 * p + 2.0) + 1 * (2 * p - 2))));
    }

    protected static void addParticleBeam(RenderingData worktable, CraftingWorktableBlockEntity.Progress progress, RenderingData pedestal, class_1937 level, float partialTick) {
        if (pedestal.stack.method_7960()) return;

        if (level.field_9229.method_43057() < Wizcraft.getConfig().animationParticlesAmount.modifier) {
            var temporalOffset = Math.abs(class_3532.method_15374((progress.remainingCraftingTime() + partialTick)));
            var path = pedestal.above.method_1035(worktable.above);
            var pos = pedestal.above.method_1019(path.method_1021(Math.min(0.6, temporalOffset * progress.value())));
            var velocity = path.method_1029().method_1021(getVelocityForProgress(progress.value()));
            RenderingUtil.addParticle(level, pedestal.particleOptions, pos, velocity);
        }
    }

    // ALL, and I mean - ALL parenthesis matter here
    protected static double getRadiusForProgress(double p) {
        return 1.75 * (-4.3 / (3.6 * p - 6.35) - 1.85 * p + 0.3);
    }

    protected static void addParticleHurricane(RenderingData worktable, CraftingWorktableBlockEntity.Progress progress, RenderingData pedestal, class_1937 level, float partialTick) {
        if (pedestal.stack.method_7960()) return;

        var temporalOffset = Math.abs(class_3532.method_15374((progress.remainingCraftingTime() + partialTick)));
        for (int i = 0; i < (1 - progress.value()) * 3 * Wizcraft.getConfig().animationParticlesAmount.modifier; i++) {
            var theta = 2f * class_3532.field_29844 * temporalOffset + i * temporalOffset;
            var r = getRadiusForProgress(progress.value());
            var hx = r * class_3532.method_15362(theta);
            var hz = r * class_3532.method_15374(theta);
            var pos = worktable.above.method_1031(hx, 0, hz);
            // Vector tangent to a circle https://stackoverflow.com/q/40710168
            var velocity = new class_243(hz, 0, -hx).method_1029().method_1021(getVelocityForProgress(progress.value()));
            var randomizedPos = pos.method_1031(
                    (hx / 16) * level.field_9229.method_43057(),
                    (level.field_9229.method_43059() - 0.5) / 16,
                    (hz / 16) * level.field_9229.method_43057());
            RenderingUtil.addParticle(level, pedestal.particleOptions, randomizedPos, velocity);
        }
    }

    protected static void addDisintegrationParticles(class_1937 level, class_5819 random, RenderingData renderingData, CraftingWorktableBlockEntity.Progress progress) {
        if (renderingData.stack.method_7960()) return;

        var velocity = new class_243((random.method_43057() - 0.5) / 8, random.method_43059() / 16, (random.method_43057() - 0.5) / 8);
        var amount = progress.value() * 10 * Wizcraft.getConfig().animationParticlesAmount.modifier * (renderingData.stack.method_7909() instanceof class_1747 ? 3 : 1);
        for (int i = 0; i < amount; i++) {
            RenderingUtil.addParticle(level, renderingData.particleOptions, renderingData.above, velocity);
        }
    }

    @Override
    public void render(CraftingWorktableBlockEntity blockEntity, float partialTick, class_4587 poseStack, class_4597 bufferSource, int packedLight, int packedOverlay) {
        var world = blockEntity.method_10997();
        if (world == null) return;

        var worktable = new RenderingData(blockEntity.method_11016(), blockEntity.getHeldStackCopy());
        var progress = blockEntity.getProgress();
        var pedestals = blockEntity.getNonEmptyPedestalPositions().stream()
                .map(world::method_8321)
                .flatMap(it -> it instanceof LensingPedestalBlockEntity pedestal ? Stream.of(pedestal) : Stream.empty())
                .map(pedestal -> new RenderingData(pedestal.method_11016(), pedestal.getHeldStackCopy()))
                .toList();

        if (pedestals.isEmpty() && worktable.stack.method_7960()) return;

        poseStack.method_22903();

        if (progress.remainingCraftingTime() > 0) {
            animateCraftingProgress(worktable, progress, pedestals, world, itemRenderer, partialTick, poseStack, bufferSource);
        } else {
            levitateItems(worktable, 0, pedestals, world, itemRenderer, partialTick, poseStack, bufferSource);
        }

        poseStack.method_22909();
    }

    public record RenderingData(class_2338 pos, class_243 center, class_243 above, class_1799 stack,
                                @Nullable class_2394 particleOptions) {
        private RenderingData(class_2338 pos, class_1799 stack) {
            this(pos, pos.method_46558(), pos.method_46558().method_1031(0, 0.75, 0), stack, stack.method_7960() ? null : new class_2392(WizcraftParticleTypes.SPAGHETTIFICATION, stack));
        }
    }
}
