package falseresync.wizcraft.client.render.blockentity;

import falseresync.wizcraft.client.render.RenderingUtil;
import falseresync.wizcraft.common.Wizcraft;
import falseresync.wizcraft.common.blockentity.CrucibleBlockEntity;
import falseresync.wizcraft.common.data.WizcraftAttachments;
import net.minecraft.class_1921;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3612;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_827;
import net.minecraft.class_918;

public class CrucibleRenderer implements class_827<CrucibleBlockEntity> {
    private final class_918 itemRenderer;
    private final class_327 textRenderer;
    private final class_310 client;

    public CrucibleRenderer(class_5614.class_5615 ctx) {
        itemRenderer = ctx.method_43335();
        textRenderer = ctx.method_32143();
        client = class_310.method_1551();
    }

    @Override
    public void render(CrucibleBlockEntity entity, float partialTick, class_4587 poseStack, class_4597 bufferSource, int packedLight, int packedOverlay) {
        if (client.field_1724 != null
                && client.field_1724.hasAttached(WizcraftAttachments.HAS_TRUESEER_GOGGLES)
                && client.field_1724.method_19538().method_24802(entity.method_11016().method_46558(), Wizcraft.getConfig().cometWarpBeaconDisplayRange)) {
            var stacks = entity.getInventory().method_54454();
            poseStack.method_22903();
            poseStack.method_22904(0.5, 1.25, 0.5);
            for (int i = 0; i < stacks.size(); i++) {
                var stack = stacks.get(i);
                if (stack.method_7960()) {
                    continue;
                }

                poseStack.method_22903();
                poseStack.method_22904(0.1, 0.5 * i, 0);
                poseStack.method_22907(client.field_1773.method_19418().method_23767());

                poseStack.method_22903();
                poseStack.method_22907(class_7833.field_40714.rotationDegrees(180));
                var textScale = 0.5f /* block sizing [-0.5,0.5] */ * 1 / 9f /* text sizing [1,9] */ * 0.3f /* actual scale */;
                poseStack.method_22905(textScale, textScale, textScale);
                textRenderer.method_27521(
                        stack.method_7947() + "", 16, -4, 0xFF_FF_FF, true,
                        poseStack.method_23760().method_23761(), bufferSource,
                        class_327.class_6415.field_33994, 0, packedLight);
                poseStack.method_22909();

                poseStack.method_22905(0.4f, 0.4f, 0.4f);
                itemRenderer.method_23178(stack, class_811.field_4317, packedLight, packedOverlay, poseStack, bufferSource, client.field_1687, 0);

                poseStack.method_22909();
            }
            poseStack.method_22909();
        }

        poseStack.method_22903();
        poseStack.method_46416(0, 1, 0);
        poseStack.method_22907(class_7833.field_40714.rotationDegrees(90));
        RenderingUtil.drawFluid(
                poseStack, bufferSource.getBuffer(class_1921.method_23583()),
                entity.method_10997(), entity.method_11016(), class_3612.field_15910, class_3612.field_15910.method_15785(), true,
                packedLight, packedOverlay, 0.125f, 0.75f, 0.125f, 0.75f, 0.125f);
        poseStack.method_22909();
    }
}
