package falseresync.wizcraft.client.render.entity;

import falseresync.wizcraft.common.entity.StarProjectileEntity;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5617;
import net.minecraft.class_765;
import net.minecraft.class_897;
import org.joml.Matrix4f;

import static falseresync.wizcraft.common.Wizcraft.wid;

public class StarProjectileRenderer extends class_897<StarProjectileEntity> {
    protected static final class_2960 TEXTURE = wid("textures/entity/star_projectile.png");
    private final class_1921 renderLayer;

    public StarProjectileRenderer(class_5617.class_5618 context) {
        super(context);
        renderLayer = class_1921.method_23576(TEXTURE);
    }

    protected static void vertices(class_4588 buffer, Matrix4f pm, class_4587.class_4665 entry) {
        vertex(buffer, pm, entry, 1, 1, 0, 0, -1);
        vertex(buffer, pm, entry, 1, 0, 0, 1, -1);
        vertex(buffer, pm, entry, 0, 0, 1, 1, -1);
        vertex(buffer, pm, entry, 0, 1, 1, 0, -1);

        vertex(buffer, pm, entry, 0, 1, 0, 0, 1);
        vertex(buffer, pm, entry, 0, 0, 0, 1, 1);
        vertex(buffer, pm, entry, 1, 0, 1, 1, 1);
        vertex(buffer, pm, entry, 1, 1, 1, 0, 1);
    }

    protected static void vertex(class_4588 buffer, Matrix4f positionMatrix, class_4587.class_4665 entry, int x, int y, float u, float v, int normal) {
        buffer.method_22918(positionMatrix, x, y, 0)
                .method_1336(255, 255, 255, 255)
                .method_22913(u, v)
                .method_22922(class_4608.field_21444)
                .method_60803(class_765.field_32767)
                .method_60831(entry, 0, 0, normal);
    }

    @Override
    public void render(StarProjectileEntity entity, float yaw, float partialTick, class_4587 poseStack, class_4597 bufferSource, int packedLight) {
        poseStack.method_22903();

        var entry = poseStack.method_23760();
        var pm = entry.method_23761();
        var buffer = bufferSource.getBuffer(renderLayer);

        poseStack.method_22907(field_4676.method_24197());
        poseStack.method_46416(-0.5f, 0, 0);
        poseStack.method_22905(0.75f, 0.75f, 0.75f);
        vertices(buffer, pm, entry);

        poseStack.method_22909();

        super.method_3936(entity, yaw, partialTick, poseStack, bufferSource, packedLight);
    }

    @Override
    public class_2960 getTextureLocation(StarProjectileEntity entity) {
        return TEXTURE;
    }
}