package falseresync.wizcraft.client.render.world;

import falseresync.lib.math.Color;
import falseresync.wizcraft.client.render.RenderingUtil;
import falseresync.wizcraft.common.Wizcraft;
import falseresync.wizcraft.common.data.WizcraftAttachments;
import falseresync.wizcraft.common.data.WizcraftComponents;
import falseresync.wizcraft.common.item.WizcraftItemTags;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_1059;
import net.minecraft.class_1921;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import net.minecraft.class_4730;
import net.minecraft.class_761;
import net.minecraft.class_765;
import net.minecraft.class_7833;
import org.joml.Matrix4f;

import static falseresync.wizcraft.common.Wizcraft.wid;

public class CometWarpBeaconRenderer implements WorldRenderEvents.AfterEntities, WorldRenderEvents.End {
    private static final class_1921 BASE_LAYER = class_1921.method_42600(wid("textures/world/comet_warp_beacon.png"));
    private static final class_1921 REMOTE_LAYER = class_1921.method_42600(wid("textures/world/comet_warp_beacon_remote.png"));
    private static final class_4730 CROWN_TEX = new class_4730(class_1059.field_5275, wid("world/comet_warp_beacon_crown"));
    private static final int TINT_NEARBY = Color.ofHsv(0f, 0f, 1, 0.5f).argb();
    private static final int TINT_REMOTE = Color.WHITE.argb();

    private static void drawBase(WorldRenderContext context, class_4587 poseStack, class_4588 buffer, int packedLight, int packedOverlay) {
        poseStack.method_22903();
        poseStack.method_22907(class_7833.field_40714.rotationDegrees(90));

        var rotation = (context.world().method_8510() + context.tickCounter().method_60637(true)) / 20;
        var perPanelAdjustment = new Matrix4f()
                .rotateAround(class_7833.field_40718.rotationDegrees(30), 0.5f, 0.5f, 0)
                .translate(0, 0, -0.02f);

        drawBasePart(poseStack, buffer, packedLight, packedOverlay, rotation, class_7833.field_40718, -0.01f, perPanelAdjustment);
        drawBasePart(poseStack, buffer, packedLight, packedOverlay, rotation, class_7833.field_40717, -0.02f, perPanelAdjustment);

        poseStack.method_22909();
    }

    private static void drawBasePart(class_4587 poseStack, class_4588 buffer, int packedLight, int packedOverlay, float rotation, class_7833 rotationAxis, float initialOffset, Matrix4f perPanelAdjustment) {
        poseStack.method_22903();

        poseStack.method_34425(new Matrix4f().rotateAround(rotationAxis.rotation(rotation), 0.5f, 0.5f, 0));
        RenderingUtil.drawTexture(poseStack, buffer, TINT_NEARBY, packedLight, packedOverlay, 0, 1, 0, 1, initialOffset, 0, 0.5f, 0, 0.5f);

        poseStack.method_34425(perPanelAdjustment);
        RenderingUtil.drawTexture(poseStack, buffer, TINT_NEARBY, packedLight, packedOverlay, 0, 1, 0, 1, initialOffset, 0, 0.5f, 0, 0.5f);

        poseStack.method_34425(perPanelAdjustment);
        RenderingUtil.drawTexture(poseStack, buffer, TINT_NEARBY, packedLight, packedOverlay, 0, 1, 0, 1, initialOffset, 0, 0.5f, 0, 0.5f);

        poseStack.method_22909();
    }

    @SuppressWarnings("DataFlowIssue")
    @Override
    public void afterEntities(WorldRenderContext context) {
        var player = class_310.method_1551().field_1724;
        var inGoggles = player.hasAttached(WizcraftAttachments.HAS_TRUESEER_GOGGLES);

        var wandStack = player.method_6047();
        if (!wandStack.method_31573(WizcraftItemTags.WANDS)) {
            return;
        }

        var anchor = wandStack.method_57824(WizcraftComponents.WARP_FOCUS_ANCHOR);
        var nearbyRange = inGoggles
                ? Wizcraft.getConfig().cometWarpBeaconDisplayRange + Wizcraft.getConfig().trueseerGogglesDisplayRange
                : Wizcraft.getConfig().cometWarpBeaconDisplayRange;
        if (anchor == null
                || anchor.comp_2207() != context.world().method_27983()
                || !anchor.comp_2208().method_19769(player.method_19538(), nearbyRange)
                || !context.frustum().method_23093(class_238.method_29968(anchor.comp_2208().method_46558()))) {
            return;
        }

        var poseStack = context.matrixStack();
        var light = class_761.method_23794(context.world(), anchor.comp_2208().method_10084());
        var overlay = class_4608.field_21444;

        poseStack.method_22903();

        // Adjust location
        var translation = context.camera().method_19326().method_1035(class_243.method_24954(anchor.comp_2208()));
        poseStack.method_22904(translation.field_1352, translation.field_1351, translation.field_1350);

        var buffer = context.consumers().getBuffer(BASE_LAYER);
        drawBase(context, poseStack, buffer, light, overlay);

        poseStack.method_22903();
        var adjustment = new Matrix4f()
                .rotateAround(class_7833.field_40714.rotationDegrees(180), 0, 0.5f, 0)
                .translate(0, 0.25f, -1)
                .scaleAround(0.5f, 0.5f, 0.5f, 0.5f);
        poseStack.method_34425(adjustment);

        var perPanelAdjustment = new Matrix4f()
                .rotateAround(class_7833.field_40716.rotationDegrees(60), 0.5f, 0, 0.5f);
        var sprite = CROWN_TEX.method_24148();
        var crownBuffer = CROWN_TEX.method_24145(context.consumers(), class_1921::method_42600);
        for (int i = 0; i < 6; i++) {
            poseStack.method_34425(perPanelAdjustment);
            RenderingUtil.drawSprite(poseStack, crownBuffer, sprite, TINT_NEARBY, light, overlay, 0, 1, 0, 1, -0.365f);
        }

        poseStack.method_22909();

        poseStack.method_22909();

    }

    @Override
    public void onEnd(WorldRenderContext context) {
        var player = class_310.method_1551().field_1724;
        if (!player.hasAttached(WizcraftAttachments.HAS_TRUESEER_GOGGLES)) {
            return;
        }

        var wandStack = player.method_6047();
        if (!wandStack.method_31573(WizcraftItemTags.WANDS)) {
            return;
        }

        var anchor = wandStack.method_57824(WizcraftComponents.WARP_FOCUS_ANCHOR);
        var remoteRange = Wizcraft.getConfig().trueseerGogglesDisplayRange * 16;
        if (anchor == null
                || anchor.comp_2207() != context.world().method_27983()
                || !anchor.comp_2208().method_19769(player.method_19538(), remoteRange)
                || !context.frustum().method_23093(class_238.method_29968(anchor.comp_2208().method_46558()))) {
            return;
        }

        var poseStack = context.matrixStack();
        var light = class_765.field_32767;
        var overlay = class_4608.field_21444;

        poseStack.method_22903();
        // Adjust location
        var translation = context.camera().method_19326().method_1035(class_243.method_24954(anchor.comp_2208()));
        var scale = (float) (class_3532.method_15345(class_3532.method_15345(translation.method_1027())) / 4f);
        poseStack.method_34425(new Matrix4f()
                .translate(translation.method_46409())
                .rotateAround(context.camera().method_23767(), 0.5f, 0.5f, 0.5f)
                .scaleAround(scale, 0.5f, 0.5f, 0.5f));
        RenderingUtil.drawTexture(poseStack, context.consumers().getBuffer(REMOTE_LAYER), TINT_REMOTE, light, overlay, 0f, 1f, 0f, 1f, 0f, 0, 1f, 0, 1f);
        poseStack.method_22909();
    }
}
