package falseresync.wizcraft.common;

import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.item.PlayerInventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1268;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import javax.annotation.Nullable;

import java.util.Optional;
import java.util.function.Function;

public class WizcraftUtil {
    private static final Function<class_1937, Integer> memo$findViewDistance = class_156.method_34866((class_1937 level) -> level.method_8608()
            ? class_310.method_1551().field_1690.method_38521()
            : ((class_3218) level).method_14178().field_17254.field_18243);

    public static <T> Optional<T> nextRandomEntry(class_3218 level, class_6862<T> tag, class_5819 random) {
        return level.method_30349()
                .method_33310(tag.comp_326())
                .map(registry -> registry.method_40260(tag))
                .flatMap(entries -> entries.method_40243(random).map(class_6880::comp_349));
    }

    /**
     * @return memoized(!) view distance
     */
    public static int findViewDistance(class_1937 world) {
        return memo$findViewDistance.apply(world);
    }

    public static long exchangeStackInSlotWithHand(class_1657 player, class_1268 hand, InventoryStorage storage, int slot, int maxAmount, @Nullable TransactionContext transaction) {
        var playerStack = player.method_5998(hand);
        var storedVariant = storage.getSlot(slot).getResource();

        if (storedVariant.isBlank() && !playerStack.method_7960()) {
            return StorageUtil.move(PlayerInventoryStorage.of(player), storage, variant -> variant.matches(playerStack), maxAmount, transaction);
        }

        if (!storedVariant.isBlank() && playerStack.method_7960()) {
            return StorageUtil.move(storage, PlayerInventoryStorage.of(player), variant -> variant.equals(storedVariant), maxAmount, transaction);
        }

        return 0;
    }

    public static class_2338 fuzzyPos(class_5819 random, int radius, class_2338 pos) {
        return pos.method_10069(random.method_43048(radius) - radius, 0, random.method_43048(radius) - radius);
    }
}
