package falseresync.wizcraft.common.block;

import com.mojang.serialization.MapCodec;
import falseresync.wizcraft.common.WizcraftUtil;
import falseresync.wizcraft.common.blockentity.LensingPedestalBlockEntity;
import javax.annotation.Nullable;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2338;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_9062;

public class LensingPedestalBlock extends class_2237 {
    public static final MapCodec<LensingPedestalBlock> CODEC = method_54094(LensingPedestalBlock::new);
    public static final class_265 SHAPE = method_9541(4, 0, 4, 12, 16, 12);

    protected LensingPedestalBlock(class_2251 settings) {
        super(settings);
    }

    @Override
    protected MapCodec<LensingPedestalBlock> method_53969() {
        return field_46280;
    }

    @Nullable
    @Override
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new LensingPedestalBlockEntity(pos, state);
    }

    @Override
    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return SHAPE;
    }

    @Override
    protected class_9062 method_55765(class_1799 stack, class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (world.method_8321(pos) instanceof LensingPedestalBlockEntity pedestal) {
            if (world.method_8608()) {
                return class_9062.field_47728;
            }

            var exchanged = WizcraftUtil.exchangeStackInSlotWithHand(player, hand, pedestal.getStorage(), 0, 1, null);
            if (exchanged == 1) {
                return class_9062.field_47729;
            }
        }

        return super.method_55765(stack, state, world, pos, player, hand, hit);
    }

    @Override
    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        if (!state.method_27852(newState.method_26204())) {
            if (world.method_8321(pos) instanceof LensingPedestalBlockEntity pedestal) {
                class_1264.method_5451(world, pos, pedestal.getInventory());
            }

            super.method_9536(state, world, pos, newState, moved);
        }
    }
}