package falseresync.wizcraft.common.block;

import com.mojang.serialization.MapCodec;
import falseresync.wizcraft.common.WizcraftUtil;
import falseresync.wizcraft.common.blockentity.WorktableBlockEntity;
import falseresync.wizcraft.common.item.WizcraftItems;
import javax.annotation.Nullable;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2338;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_5558;
import net.minecraft.class_9062;

public abstract class WorktableBlock<B extends WorktableBlockEntity> extends class_2237 {
    public static final class_265 SHAPE = class_259.method_17786(
            /* Panel */ class_259.method_1081(0, 14 / 16f, 0, 16 / 16f, 16 / 16f, 16 / 16f),
            /* Base */ class_259.method_1081(2 / 16f, 0, 2 / 16f, 14 / 16f, 4 / 16f, 14 / 16f),
            /* Post */ class_259.method_1081(4 / 16f, 4 / 16f, 4 / 16f, 12 / 16f, 14 / 16f, 12 / 16f)
    );

    public WorktableBlock(class_2251 settings) {
        super(settings);
    }

    // Dear vanilla, suck dick for Codecs. Those are really the epitome of PITA
    // But noooooooo, it MUUUUUST be data-driven, ffs
    @Override
    protected MapCodec<? extends class_2237> method_53969() {
        throw new UnsupportedOperationException();
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return SHAPE;
    }

    @Override
    public String method_9539() {
        return WizcraftBlocks.DUMMY_WORKTABLE.method_9539();
    }

    @Override
    public class_1799 method_9574(class_4538 world, class_2338 pos, class_2680 state) {
        return new class_1799(WizcraftItems.WORKTABLE);
    }

    @Nullable
    @Override
    public abstract class_2586 method_10123(class_2338 pos, class_2680 state);

    @Nullable
    @Override
    public abstract <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type);

    public abstract WorktableVariant<B> getVariant();

    @Override
    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    @Override
    protected class_9062 method_55765(class_1799 stack, class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (world.method_8321(pos) instanceof WorktableBlockEntity worktable) {
            if (world.method_8608()) return class_9062.field_47729;

            if (worktable.shouldExchangeFor(stack)) {
                var exchanged = WizcraftUtil.exchangeStackInSlotWithHand(player, hand, worktable.getStorage(), 0, 1, null);
                if (exchanged == 1) {
                    return class_9062.field_47729;
                }
            }

            if (worktable.canBeActivatedBy(stack)) {
                worktable.activate(player);
                return class_9062.field_47728;
            }
        }

        return super.method_55765(stack, state, world, pos, player, hand, hit);
    }

    @Override
    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        if (!state.method_27852(newState.method_26204())) {
            if (world.method_8321(pos) instanceof WorktableBlockEntity worktable) {
                worktable.remove(world, pos);
                class_1264.method_5451(world, pos, worktable.getInventory());
            }

            super.method_9536(state, world, pos, newState, moved);
        }
    }
}
