package falseresync.wizcraft.common.block;

import falseresync.lib.blockpattern.BetterBlockPattern;
import falseresync.wizcraft.common.blockentity.WorktableBlockEntity;
import javax.annotation.Nullable;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Supplier;

@SuppressWarnings("NotNullFieldNotInitialized")
public class WorktableBuilder<B extends WorktableBlockEntity> {
    protected Supplier<class_2591<B>> type;
    @Nullable
    protected class_5558<B> ticker;
    protected Supplier<BetterBlockPattern> pattern;
    @Nullable
    protected BiPredicate<class_3218, class_3222> preconditions;

    public WorktableBuilder<B> type(Supplier<class_2591<B>> type) {
        this.type = type;
        return this;
    }

    public WorktableBuilder<B> ticker(class_5558<B> ticker) {
        this.ticker = ticker;
        return this;
    }

    public WorktableBuilder<B> pattern(Supplier<BetterBlockPattern> pattern) {
        this.pattern = pattern;
        return this;
    }

    public WorktableBuilder<B> preconditions(BiPredicate<class_3218, class_3222> preconditions) {
        this.preconditions = preconditions;
        return this;
    }

    public Function<class_4970.class_2251, WorktableBlock<B>> build() {
        Objects.requireNonNull(type, "BlockEntity type cannot be null");
        Objects.requireNonNull(pattern, "Pattern cannot be null");
        preconditions = preconditions == null ? (world, player) -> true : preconditions;

        return settings -> new WorktableBlock<>(settings) {
            private final WorktableVariant<B> VARIANT = new WorktableVariant<>(() -> this, pattern, preconditions);

            @Override
            public class_2586 method_10123(class_2338 pos, class_2680 state) {
                return type.get().method_11032(pos, state);
            }

            @Override
            @Nullable
            public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
                //noinspection DataFlowIssue
                return method_31618(type, WorktableBuilder.this.type.get(), ticker);
            }

            @Override
            public WorktableVariant<B> getVariant() {
                return VARIANT;
            }
        };
    }
}
