package falseresync.wizcraft.common.block;

import falseresync.lib.blockpattern.BetterBlockPattern;
import falseresync.wizcraft.common.blockentity.WorktableBlockEntity;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public record WorktableVariant<T extends WorktableBlockEntity>(
        Supplier<WorktableBlock<T>> block,
        Supplier<BetterBlockPattern> pattern,
        BiPredicate<class_3218, class_3222> preconditions
) {
    private static final List<WorktableVariant<?>> UNBAKED_VARIANTS = new ArrayList<>();
    private static final List<Baked<?>> BAKED_VARIANTS = new ArrayList<>();

    public static void register(WorktableVariant<?> variant) {
        UNBAKED_VARIANTS.add(variant);
    }

    public static List<Baked<?>> getAll() {
        if (BAKED_VARIANTS.isEmpty()) {
            UNBAKED_VARIANTS.stream()
                    .map(variant -> new Baked<>(variant.block.get(), variant.pattern.get(), variant.preconditions()))
                    .sorted(Comparator.comparingInt(variantA -> variantA.pattern.getSize()))
                    .collect(Collectors.toCollection(() -> BAKED_VARIANTS));
        }
        return BAKED_VARIANTS;
    }

    public static List<Baked<?>> getForPlayer(class_3218 world, class_3222 player) {
        return getAll().stream().filter(variant -> variant.preconditions.test(world, player)).toList();
    }

    public static List<Matched<?>> getForPlayerAndSearchAround(class_3218 world, class_3222 player, class_2338 startingPos) {
        return getForPlayer(world, player)
                .stream()
                .map(baked -> new Matched<>(baked.block, baked.pattern.searchAround(world, startingPos)))
                .collect(Collectors.toList());
    }

    public record Baked<T extends WorktableBlockEntity>(
            WorktableBlock<T> block,
            BetterBlockPattern pattern,
            BiPredicate<class_3218, class_3222> preconditions
    ) {}

    public record Matched<T extends WorktableBlockEntity>(
            WorktableBlock<T> block,
            BetterBlockPattern.Match match
    ) {}
}