package falseresync.wizcraft.common.blockentity;

import falseresync.wizcraft.common.CommonKeys;
import falseresync.wizcraft.common.Wizcraft;
import falseresync.wizcraft.common.data.WizcraftComponents;
import falseresync.wizcraft.common.item.WizcraftItems;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.minecraft.class_1262;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_7225;
import javax.annotation.Nullable;

public class ChargingWorktableBlockEntity extends WorktableBlockEntity {
    protected final class_1277 inventory = new class_1277(1) {
        @Override
        public int method_5444() {
            return 1;
        }
    };
    protected final InventoryStorage storage = InventoryStorage.of(inventory, null);
    protected boolean charging = false;

    public ChargingWorktableBlockEntity(class_2338 pos, class_2680 state) {
        super(WizcraftBlockEntities.CHARGING_WORKTABLE, pos, state);
        inventory.method_5489(sender -> method_5431());
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, ChargingWorktableBlockEntity worktable) {
        worktable.tick(world, pos, state);
    }

    @Override
    public class_1277 getInventory() {
        return inventory;
    }

    @Override
    public InventoryStorage getStorage() {
        return storage;
    }

    public class_1799 getHeldStackCopy() {
        return inventory.method_5438(0).method_7972();
    }

    public boolean isCharging() {
        return charging;
    }

    @Override
    public void activate(class_1657 player) {

    }

    @Override
    public boolean shouldExchangeFor(class_1799 stack) {
        return stack.method_31574(WizcraftItems.WAND) || stack.method_7960();
    }

    @Override
    public void remove(class_1937 world, class_2338 pos) {

    }

    protected void tick(class_1937 world, class_2338 pos, class_2680 state) {
        if (world.method_8608()) {
            return;
        }

        var heldStack = inventory.method_5438(0);
        if (!heldStack.method_31574(WizcraftItems.WAND)) {
            if (charging) {
                charging = false;
                method_5431();
            }
            return;
        }

        if (Wizcraft.getChargeManager().isWandFullyCharged(heldStack)) return;

        if (world.method_23886() && world.field_9229.method_43057() < 0.25 || world.field_9229.method_43057() < 0.0625) {
            heldStack.method_57368(WizcraftComponents.WAND_CHARGE, 0, current -> current + 1);

            var isFullyCharged = Wizcraft.getChargeManager().isWandFullyCharged(heldStack);
            if (charging && isFullyCharged || !charging && !isFullyCharged) {
                charging = !charging;
                method_5431();
            }
        }
    }

    @Override
    public void method_5431() {
        super.method_5431();
        if (field_11863 != null) {
            field_11863.method_8413(field_11867, method_11010(), method_11010(), class_2248.field_31036);
            field_11863.method_35230(field_11867.method_10086(2), WizcraftBlockEntities.LENS).ifPresent(lens -> lens.setOn(charging));
        }
    }

    @Override
    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);

        class_1262.method_5426(nbt, inventory.method_54454(), registryLookup);

        nbt.method_10556(CommonKeys.CHARGING, charging);
    }

    @Override
    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);

        inventory.method_54454().clear();
        class_1262.method_5429(nbt, inventory.method_54454(), registryLookup);

        charging = false;
        if (nbt.method_10573(CommonKeys.CHARGING, class_2520.field_33251)) {
            charging = nbt.method_10577(CommonKeys.CHARGING);
        }
    }

    @Nullable
    @Override
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585(this);
    }

    @Override
    public class_2487 method_16887(class_7225.class_7874 registryLookup) {
        return method_38244(registryLookup);
    }
}