package falseresync.wizcraft.common.blockentity;

import falseresync.wizcraft.common.CommonKeys;
import falseresync.wizcraft.common.WizcraftSounds;
import falseresync.wizcraft.common.recipe.LensedWorktableRecipe;
import falseresync.wizcraft.common.recipe.SimpleInventoryRecipeInput;
import falseresync.wizcraft.common.recipe.WizcraftRecipes;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.minecraft.class_1262;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2770;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import javax.annotation.Nullable;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class CraftingWorktableBlockEntity extends WorktableBlockEntity {
    public static final int IDLE_SEARCH_COOLDOWN = 5;
    protected final List<LensingPedestalBlockEntity> pedestals = new ArrayList<>();
    protected final List<class_2338> nonEmptyPedestalPositions = new ArrayList<>();
    protected final class_1277 inventory = new class_1277(1) {
        @Override
        public int method_5444() {
            return 1;
        }
    };
    protected final InventoryStorage storage = InventoryStorage.of(inventory, null);
    protected final SimpleInventoryRecipeInput virtualCombinedInventory = new SimpleInventoryRecipeInput(5) {
        @Override
        public int method_5444() {
            return 1;
        }
    };
    protected int remainingIdleSearchCooldown = 0;
    protected int remainingCraftingTime = 0;
    protected int craftingTime = 0;
    protected class_1799 currentlyCrafted = class_1799.field_8037;
    protected @Nullable class_2960 currentRecipeId;
    protected @Nullable LensedWorktableRecipe currentRecipe;

    public CraftingWorktableBlockEntity(class_2338 pos, class_2680 state) {
        super(WizcraftBlockEntities.CRAFTING_WORKTABLE, pos, state);
        inventory.method_5489(sender -> method_5431());
    }

    // PUBLIC INTERFACE

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, CraftingWorktableBlockEntity worktable) {
        worktable.tick(world, pos, state);
    }

    @Override
    public void activate(@Nullable class_1657 player) {
        if (field_11863 == null || field_11863.method_8608()) return;

        searchPedestals(field_11863, field_11867);
        if (pedestals.size() < 4) {
            if (player instanceof class_3222 serverPlayer) {
                player.method_17356(class_3417.field_14962, class_3419.field_15245, 1f, 1f);
                player.method_7353(class_2561.method_43471("hud.wizcraft.worktable.incomplete_worktable"), true);
            }
            return;
        }

        updateVirtualCombinedInventory();
        field_11863.method_8433()
                .method_8132(WizcraftRecipes.LENSED_WORKTABLE, virtualCombinedInventory.recipeInput(), field_11863)
                .ifPresent(this::beginCrafting);
    }

    @Override
    public void remove(class_1937 world, class_2338 pos) {
        searchPedestals(world, pos);
        pedestals.forEach(pedestal -> pedestal.linkTo(null));
    }

    public List<class_2338> getNonEmptyPedestalPositions() {
        return nonEmptyPedestalPositions;
    }

    public Progress getProgress() {
        return new Progress(
                currentlyCrafted,
                remainingCraftingTime,
                craftingTime - remainingCraftingTime,
                1 - (float) remainingCraftingTime / craftingTime);
    }

    public class_1799 getHeldStackCopy() {
        return inventory.method_5438(0).method_7972();
    }

    @Override
    public class_1277 getInventory() {
        return inventory;
    }

    // TICKERS

    @Override
    public InventoryStorage getStorage() {
        return storage;
    }

    protected void tick(class_1937 world, class_2338 pos, class_2680 state) {
        if (currentRecipe == null && currentRecipeId != null) {
            updateVirtualCombinedInventory();
            world.method_8433().method_8130(currentRecipeId)
                    .flatMap(entry -> entry.comp_1933() instanceof LensedWorktableRecipe recipe
                            ? Optional.of(recipe)
                            : Optional.empty())
                    .ifPresentOrElse(recipe -> initStaticRecipeData(world, recipe), this::reset);
        }

        if (world.field_9236) return;

        if (currentRecipe != null) {
            tickCrafting(world, pos, currentRecipe);
            return;
        }

        tickIdle(world, pos);
    }

    protected void tickCrafting(class_1937 world, class_2338 pos, LensedWorktableRecipe recipe) {
        remainingCraftingTime -= 1;
        searchPedestals(world, pos);
        method_5431();
        if (pedestals.size() < 4) {
            interruptCrafting();
            return;
        }

        updateVirtualCombinedInventory();
        if (!recipe.method_8115(virtualCombinedInventory.recipeInput(), world)) {
            interruptCrafting();
            return;
        }

        if (remainingCraftingTime <= 0) {
            finishCrafting();
            return;
        }
    }

    protected void tickIdle(class_1937 world, class_2338 pos) {
        if (remainingIdleSearchCooldown > 0) {
            remainingIdleSearchCooldown -= 1;
            return;
        }

        remainingIdleSearchCooldown = IDLE_SEARCH_COOLDOWN;
        searchPedestals(world, pos);
    }

    // DATA-MUTATING INTERNALS

    protected void searchPedestals(class_1937 world, class_2338 pos) {
        pedestals.clear();

        for (var pedestalPos : List.of(pos.method_10076(2), pos.method_10088(2), pos.method_10077(2), pos.method_10089(2))) {
            if (world.method_8321(pedestalPos) instanceof LensingPedestalBlockEntity pedestal) {
                if (!pedestal.isLinkedTo(this)) {
                    world.method_22352(pos, true);
                    world.method_8396(null, pos, class_3417.field_14890, class_3419.field_15245, 1, 1);
                } else {
                    pedestals.add(pedestal);
                    pedestal.linkTo(this);
                }
            }
        }
    }

    protected void updateVirtualCombinedInventory() {
        virtualCombinedInventory.method_5447(0, inventory.method_5438(0).method_7972());
        for (int i = 0; i < pedestals.size(); i++) {
            virtualCombinedInventory.method_5447(i + 1, pedestals.get(i).getHeldStackCopy());
        }
    }

    protected void beginCrafting(class_8786<LensedWorktableRecipe> recipeEntry) {
        if (field_11863 == null || field_11863.method_8608()) return;

        currentRecipeId = recipeEntry.comp_1932();
        initStaticRecipeData(field_11863, recipeEntry.comp_1933());
        remainingCraftingTime = recipeEntry.comp_1933().getCraftingTime();
        method_5431();

        field_11863.method_8396(null, field_11867, class_3417.field_22452.comp_349(), class_3419.field_15245, 1f, 1f);
    }

    protected void interruptCrafting() {
        if (field_11863 == null || field_11863.method_8608()) return;

        reset();
        onInterrupted(this, field_11863, field_11867);
    }

    protected void finishCrafting() {
        if (field_11863 == null || field_11863.method_8608() || currentRecipe == null) return;

        inventory.method_5447(0, currentRecipe.method_8116(virtualCombinedInventory.recipeInput(), field_11863.method_30349()));
        var remainders = currentRecipe.method_8111(virtualCombinedInventory.recipeInput());
        for (int i = 0; i < pedestals.size(); i++) {
            pedestals.get(i).onCrafted(remainders.get(i + 1));
        }

        reset();
        field_11863.method_8396(null, field_11867, WizcraftSounds.WORKTABLE_SUCCESS, class_3419.field_15245, 1f, 1f);
        var stopSoundPacket = new class_2770(class_3417.field_22452.comp_349().method_14833(), class_3419.field_15245);
        for (var player : PlayerLookup.tracking(this)) {
            player.field_13987.method_14364(stopSoundPacket);
        }
    }


    protected void initStaticRecipeData(class_1937 world, LensedWorktableRecipe recipe) {
        currentRecipe = recipe;
        craftingTime = recipe.getCraftingTime();
        currentlyCrafted = currentRecipe.method_8116(virtualCombinedInventory.recipeInput(), world.method_30349());
    }

    protected void reset() {
        virtualCombinedInventory.method_5448();
        currentRecipeId = null;
        currentRecipe = null;
        craftingTime = 0;
        currentlyCrafted = class_1799.field_8037;
        remainingCraftingTime = 0;
        remainingIdleSearchCooldown = 0;

        method_5431();
    }

    // DATA-SAVING INTERNALS

    @Override
    public void method_5431() {
        super.method_5431();
        if (field_11863 != null) {
            field_11863.method_8413(field_11867, method_11010(), method_11010(), class_2248.field_31036);
        }
    }

    @Override
    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);

        class_1262.method_5426(nbt, inventory.method_54454(), registryLookup);

        if (!pedestals.isEmpty()) {
            var nbtList = pedestals.stream()
                    .filter(pedestal -> !pedestal.getHeldStackCopy().method_7960())
                    .map(class_2586::method_11016)
                    .map(class_2512::method_10692)
                    .map(it -> {
                        var tag = new class_2487();
                        tag.method_10566("pedestal", it);
                        return tag;
                    })
                    .collect(Collectors.toCollection(class_2499::new));
            nbt.method_10566(CommonKeys.NON_EMPTY_PEDESTALS, nbtList);
        } else {
            nbt.method_10551(CommonKeys.NON_EMPTY_PEDESTALS);
        }

        if (currentRecipeId != null) {
            nbt.method_10582(CommonKeys.CURRENT_RECIPE, currentRecipeId.toString());
        } else {
            nbt.method_10551(CommonKeys.CURRENT_RECIPE);
        }

        if (remainingCraftingTime != 0) {
            nbt.method_10569(CommonKeys.REMAINING_CRAFTING_TIME, remainingCraftingTime);
        } else {
            nbt.method_10551(CommonKeys.REMAINING_CRAFTING_TIME);
        }
    }

    @Override
    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);

        inventory.method_54454().clear();
        class_1262.method_5429(nbt, inventory.method_54454(), registryLookup);

        nonEmptyPedestalPositions.clear();
        if (nbt.method_10573(CommonKeys.NON_EMPTY_PEDESTALS, class_2520.field_33259)) {
            var nbtList = nbt.method_10554(CommonKeys.NON_EMPTY_PEDESTALS, class_2520.field_33260);
            for (int i = 0; i < nbtList.size(); i++) {
                class_2512.method_10691(nbtList.method_10602(i), "pedestal").ifPresent(nonEmptyPedestalPositions::add);
            }
        }

        currentRecipeId = null;
        if (nbt.method_10573(CommonKeys.CURRENT_RECIPE, class_2520.field_33258)) {
            currentRecipeId = class_2960.method_12829(nbt.method_10558(CommonKeys.CURRENT_RECIPE));
        }

        remainingCraftingTime = 0;
        if (nbt.method_10573(CommonKeys.REMAINING_CRAFTING_TIME, class_2520.field_33253)) {
            remainingCraftingTime = nbt.method_10550(CommonKeys.REMAINING_CRAFTING_TIME);
        }
    }

    @Nullable
    @Override
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585(this);
    }

    @Override
    public class_2487 method_16887(class_7225.class_7874 registryLookup) {
        return method_38244(registryLookup);
    }

    // OTHER

    public record Progress(class_1799 currentlyCrafted, int remainingCraftingTime, int passedCraftingTime, float value) {
    }
}