package falseresync.wizcraft.common.blockentity;

import falseresync.wizcraft.common.Reports;
import falseresync.wizcraft.common.recipe.CrucibleRecipe;
import falseresync.wizcraft.common.recipe.SimpleInventoryRecipeInput;
import falseresync.wizcraft.common.recipe.WizcraftRecipes;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.minecraft.class_1262;
import net.minecraft.class_1277;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2770;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import javax.annotation.Nullable;


public class CrucibleBlockEntity extends class_2586 {
    protected final SimpleInventoryRecipeInput inventory = new SimpleInventoryRecipeInput(5) {
        @Override
        public int method_5444() {
            return 10;
        }
    };

    public CrucibleBlockEntity(class_2338 pos, class_2680 state) {
        super(WizcraftBlockEntities.CRUCIBLE, pos, state);
        inventory.method_5489(change -> method_5431());
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, CrucibleBlockEntity crucible) {
        if (world.field_9236) return;

        world.method_8390(class_1542.class, class_238.method_54784(pos, pos.method_10084()).method_35580(2 / 16f, 0.75, 2 / 16f), entity -> true).forEach(entity -> {
            var stack = entity.method_6983();
            var inventory = crucible.inventory;
            var max = inventory.method_58350(stack);
            // If there's too many items, they get lost
            if (inventory.method_43256(contained -> class_1799.method_31577(contained, stack) && contained.method_7947() + stack.method_7947() > max) || stack.method_7947() > max) {
                inventory.method_20631(stack.method_7909(), max);
                inventory.method_5491(stack.method_46651(stack.method_7947() - max));
                onInterrupted(crucible, world, pos);
            } else if (!inventory.method_5491(stack.method_7972()).method_7960()) {
                inventory.method_5441(0);
                inventory.method_5447(0, inventory.method_5438(1));
                inventory.method_5447(1, inventory.method_5438(2));
                inventory.method_5447(2, inventory.method_5438(3));
                inventory.method_5447(3, inventory.method_5438(4));
                onInterrupted(crucible, world, pos);
            }
            entity.method_31472();
        });

        world.method_8433().method_8132(WizcraftRecipes.CRUCIBLE, crucible.inventory.recipeInput(), world).ifPresent(crucible::craft);
    }

    private static void onInterrupted(CrucibleBlockEntity crucible, class_1937 world, class_2338 pos) {
        // TODO: bad effects
        world.method_8396(null, pos, class_3417.field_14556, class_3419.field_15245, 1f, 1f);
        Reports.addSmoke(world, pos.method_46558().method_1031(0, 0.75, 0));
        var stopSoundPacket = new class_2770(class_3417.field_22452.comp_349().method_14833(), class_3419.field_15245);
        for (var player : PlayerLookup.tracking(crucible)) {
            player.field_13987.method_14364(stopSoundPacket);
        }
    }

    public class_1277 getInventory() {
        return inventory;
    }

    public void craft(class_8786<CrucibleRecipe> recipeEntry) {
        if (field_11863 == null) return;

        var result = recipeEntry.comp_1933().method_8116(inventory.recipeInput(), field_11863.method_30349());
        inventory.method_5448();
        var entityPos = field_11867.method_46558().method_1031(0, 1.25, 0);
        var entity = new class_1542(field_11863, entityPos.field_1352, entityPos.field_1351, entityPos.field_1350, result, 0, 0, 0);
        entity.method_5875(true);
        field_11863.method_8649(entity);
    }

    @Override
    public void method_5431() {
        super.method_5431();
        if (field_11863 != null) {
            field_11863.method_8413(field_11867, method_11010(), method_11010(), class_2248.field_31036);
        }
    }

    @Override
    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        class_1262.method_5426(nbt, inventory.method_54454(), registryLookup);
    }

    @Override
    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        inventory.method_54454().clear();
        class_1262.method_5429(nbt, inventory.method_54454(), registryLookup);
    }

    @Nullable
    @Override
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585(this);
    }

    @Override
    public class_2487 method_16887(class_7225.class_7874 registryLookup) {
        return method_38244(registryLookup);
    }
}
