package falseresync.wizcraft.common.blockentity;

import falseresync.wizcraft.common.CommonKeys;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.minecraft.class_1262;
import net.minecraft.class_1277;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_7225;
import javax.annotation.Nullable;

import java.util.Optional;

public class LensingPedestalBlockEntity extends class_2586 {
    protected final class_1277 inventory = new class_1277(1) {
        @Override
        public int method_5444() {
            return 1;
        }
    };
    protected final InventoryStorage storage = InventoryStorage.of(inventory, null);
    protected @Nullable class_2338 linkedTo = null;

    public LensingPedestalBlockEntity(class_2338 pos, class_2680 state) {
        super(WizcraftBlockEntities.LENSING_PEDESTAL, pos, state);
        inventory.method_5489(sender -> method_5431());
    }

    // PUBLIC INTERFACE

    public void onCrafted(class_1799 remainder) {
        inventory.method_5447(0, remainder);
    }

    public void linkTo(@Nullable class_2586 controller) {
        linkedTo = controller != null ? controller.method_11016() : null;
        method_5431();
    }

    public boolean isLinked() {
        return linkedTo != null;
    }

    public boolean isLinkedTo(class_2586 controller) {
        return !isLinked() || controller.method_11016().equals(linkedTo);
    }

    public class_1799 getHeldStackCopy() {
        return inventory.method_5438(0).method_7972();
    }

    public class_1277 getInventory() {
        return inventory;
    }

    public InventoryStorage getStorage() {
        return storage;
    }

    // DATA-SAVING INTERNALS

    @Override
    public void method_5431() {
        super.method_5431();
        if (field_11863 != null) {
            field_11863.method_8413(field_11867, method_11010(), method_11010(), class_2248.field_31036);
            Optional.ofNullable(linkedTo).map(field_11863::method_8321).ifPresent(class_2586::method_5431);
        }
    }

    @Override
    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);

        class_1262.method_5426(nbt, inventory.method_54454(), registryLookup);

        if (linkedTo != null) {
            nbt.method_10566(CommonKeys.LINKED_TO, class_2512.method_10692(linkedTo));
        } else {
            nbt.method_10551(CommonKeys.LINKED_TO);
        }
    }

    @Override
    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);

        inventory.method_54454().clear();
        class_1262.method_5429(nbt, inventory.method_54454(), registryLookup);

        linkedTo = null;
        if (nbt.method_10573(CommonKeys.LINKED_TO, class_2520.field_33260)) {
            class_2512.method_10691(nbt, CommonKeys.LINKED_TO).ifPresent(it -> linkedTo = it);
        }
    }

    @Nullable
    @Override
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585(this);
    }

    @Override
    public class_2487 method_16887(class_7225.class_7874 registryLookup) {
        return method_38244(registryLookup);
    }
}