package falseresync.wizcraft.common.blockentity;

import falseresync.wizcraft.common.Reports;
import falseresync.wizcraft.common.item.WizcraftItemTags;
import falseresync.wizcraft.common.item.WizcraftItems;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2770;
import net.minecraft.class_3417;
import net.minecraft.class_3419;

public abstract class WorktableBlockEntity extends class_2586 {
    public WorktableBlockEntity(class_2591<? extends WorktableBlockEntity> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    protected static void onInterrupted(WorktableBlockEntity worktable, class_1937 world, class_2338 pos) {
        // TODO: bad effects
        world.method_8396(null, pos, class_3417.field_14556, class_3419.field_15245, 1f, 1f);
        Reports.addSmoke(world, pos.method_46558().method_1031(0, 0.75, 0));
        var stopSoundPacket = new class_2770(class_3417.field_22452.comp_349().method_14833(), class_3419.field_15245);
        for (var player : PlayerLookup.tracking(worktable)) {
            player.field_13987.method_14364(stopSoundPacket);
        }
    }

    public abstract class_1277 getInventory();

    public abstract InventoryStorage getStorage();

    public abstract void activate(class_1657 player);

    public abstract void remove(class_1937 world, class_2338 pos);

    public boolean shouldExchangeFor(class_1799 stack) {
        return !stack.method_31574(WizcraftItems.WAND);
    }

    public boolean canBeActivatedBy(class_1799 stack) {
        return stack.method_31573(WizcraftItemTags.WANDS);
    }
}
