package falseresync.wizcraft.common.data;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_5632;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record ContainerComponent(ImmutableList<class_1799> stacks, int size) implements class_5632 {
    public static final Codec<ContainerComponent> CODEC = RecordCodecBuilder.create(instance -> instance.group(
            Slot.CODEC.listOf().xmap(ContainerComponent::fromSlots, ContainerComponent::toSlots)
                    .fieldOf("slots").forGetter(ContainerComponent::stacks),
            Codec.INT.fieldOf("size").forGetter(ContainerComponent::size)
    ).apply(instance, ContainerComponent::createRespectingSize));
    public static final class_9139<class_9129, ContainerComponent> PACKET_CODEC = class_9139.method_56435(
            class_1799.field_49269, ContainerComponent::stacks,
            class_9135.field_49675, ContainerComponent::size,
            ContainerComponent::new
    );

    public ContainerComponent(List<class_1799> stacks, int size) {
        this(ImmutableList.copyOf(stacks), size);
    }

    private static ContainerComponent createRespectingSize(List<class_1799> stacks, int size) {
        if (size > stacks.size()) {
            var builder = ImmutableList.<class_1799>builder();
            builder.addAll(stacks);
            for (int i = stacks.size(); i < size; i++) {
                builder.add(class_1799.field_8037);
            }

            return new ContainerComponent(builder.build(), size);
        }

        return new ContainerComponent(stacks, size);
    }

    public static ContainerComponent createDefault(int size) {
        return new ContainerComponent(class_2371.method_10213(size, class_1799.field_8037), size);
    }

    public static List<class_1799> fromSlots(List<Slot> slots) {
        var stacks = class_2371.method_10213(slots.stream().mapToInt(Slot::index).max().orElseThrow() + 1, class_1799.field_8037);
        for (Slot slot : slots) {
            stacks.set(slot.index, slot.stack);
        }
        return stacks;
    }

    public static List<Slot> toSlots(List<class_1799> stacks) {
        var builder = ImmutableList.<Slot>builder();
        for (int i = 0; i < stacks.size(); i++) {
            var stack = stacks.get(i);
            if (!stack.method_7960()) {
                builder.add(new Slot(i, stack));
            }
        }
        return builder.build();
    }

    public int getSlotWithStack(class_1799 stack) {
        for (int i = 0; i < size(); i++) {
            if (!stacks.get(i).method_7960() && class_1799.method_31577(stack, stacks.get(i))) {
                return i;
            }
        }

        return -1;
    }

    public EphemeralInventory toModifiable() {
        return new EphemeralInventory(this);
    }

    @Override
    public String toString() {
        return "InventoryComponent" + stacks;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) return true;
        if (obj instanceof ContainerComponent that) {
            return this.stacks.size() == that.stacks.size() && class_1799.method_57362(this.stacks, that.stacks);
        } else {
            return false;
        }
    }

    @Override
    public int hashCode() {
        return class_1799.method_57361(stacks);
    }

    public record Slot(int index, class_1799 stack) {
        public static final Codec<Slot> CODEC = RecordCodecBuilder.create(instance -> instance.group(
                Codec.intRange(0, 255).fieldOf("index").forGetter(Slot::index),
                class_1799.field_24671.fieldOf("stack").forGetter(Slot::stack)
        ).apply(instance, Slot::new));
    }
}
