package falseresync.wizcraft.common.entity;

import com.google.common.base.Preconditions;
import falseresync.wizcraft.common.Wizcraft;
import falseresync.wizcraft.common.data.WizcraftAttachments;
import falseresync.wizcraft.common.data.WizcraftComponents;
import falseresync.wizcraft.common.item.WizcraftItemTags;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2940;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_4844;
import net.minecraft.class_7094;
import net.minecraft.class_8046;
import net.minecraft.class_8113;
import net.minecraft.class_8836;
import net.minecraft.class_9691;

public class EnergyVeilEntity extends class_1297 implements class_8046 {
    public static final float SCREENS_OFFSET = 0.25f;
    public static final int MINIMAL_LIFE_EXPECTANCY = 20;
    private static final class_2940<Float> RADIUS = class_2945.method_12791(EnergyVeilEntity.class, class_2943.field_13320);
    public class_7094 slideAnimationState = new class_7094();
    private int lifeExpectancy;
    @Nullable
    private class_1657 owner;
    @Nullable
    private class_1799 controllingStack;

    public EnergyVeilEntity(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    public EnergyVeilEntity(@Nullable class_1657 owner, @Nullable class_1799 controllingStack, class_1937 world) {
        this(WizcraftEntities.ENERGY_VEIL, world);
        Preconditions.checkArgument(
                controllingStack == null || owner != null,
                "Owner must not be null if a controlling stack is present");
        Preconditions.checkArgument(
                controllingStack == null || controllingStack.method_31573(WizcraftItemTags.WANDS),
                "A controlling stack must be a wand");
        this.owner = owner;
        this.controllingStack = controllingStack;

        field_6012 = 0;
        lifeExpectancy = MINIMAL_LIFE_EXPECTANCY;
        field_5960 = true;
        field_17046 = new class_243(1, 1, 1);
        method_5875(true);

        if (owner != null) {
            method_33574(owner.method_19538());
        }
        alignWithOwner();
    }

    public void incrementLifeExpectancy(int by) {
        lifeExpectancy += by;
    }

    public void alignWithOwner() {
        if (owner == null) return;
        method_18799(owner.method_19538().method_1020(method_19538()));
    }

    @Override
    protected void method_5693(class_2945.class_9222 builder) {
        builder.method_56912(RADIUS, 1.0F);
    }

    @Override
    public void method_5674(class_2940<?> data) {
        super.method_5674(data);
        if (RADIUS.equals(data)) {
            method_5857(method_33332());
        }
        if (owner != null) {
            owner.setAttached(WizcraftAttachments.ENERGY_VEIL_NETWORK_ID, method_5628());
        }
        if (method_5770().method_8608()) {
            slideAnimationState.method_41324(field_6012);
        }
    }

    @Override
    public void method_5773() {
        super.method_5773();
        alignWithOwner();
        method_5784(class_1313.field_6308, method_18798());

        if (!method_37908().field_9236) {
            repelOutsiders();

            if (field_6012 >= lifeExpectancy) {
                if (owner != null) {
                    owner.removeAttached(WizcraftAttachments.ENERGY_VEIL_NETWORK_ID);
                    if (controllingStack != null) {
                        controllingStack.method_57381(WizcraftComponents.ENERGY_VEIL_UUID);
                    }
                }
                method_31472();
            }
        }
    }

    private void repelOutsiders() {
        var entities = method_37908().method_8333(this, method_5829(), class_1301.field_6155
                .and(it -> !it.equals(owner))
                .and(it -> !isOwnedByOwner(it))
                .and(it -> !it.method_5864().method_20210(WizcraftEntityTags.PASSES_THROUGH_ENERGY_VEIL))
                .and(it -> !(it instanceof class_8836 vehicle && !vehicle.method_5782()))
                .and(it -> !(it instanceof class_8113 || it instanceof class_9691))
                .and(it -> !isComingFromAboveOrBelow(it))
                .and(it -> !isInside(it)));
        for (class_1297 entity : entities) {
            if (isOnTheEdge(entity)) {
                // dot product shows the direction. if it's negative - vectors are pointing opposite of each other
                // if it's 0 - they point orthogonally, and if it's positive - more or less in the same direction
                // compare the entity velocity and the entity-to-veil-center vectors
                // if they point to the same direction - repel the incoming entity
                var entityToOwner = entity.method_19538().method_1035(method_19538());
                var velocity = entity.method_60478();
                if (velocity.method_1026(entityToOwner) >= 0) {
                    // Deflect projectiles and fast-moving entities, push any other
                    if (velocity.method_1027() >= 0.75 || entity instanceof class_1676) {
                        entity.method_18799(velocity.method_22882().method_1021(0.5));
                        entity.field_6007 = true;
                    } else if (entity instanceof class_1309 livingEntity) {
                        livingEntity.method_6005(1, entityToOwner.field_1352, entityToOwner.field_1350);
                    } else {
                        entity.method_5784(class_1313.field_6310, entityToOwner.method_22882().method_1021(3));
                    }
                    entity.field_6037 = true;
                }
            }
        }
    }

    private boolean isOwnedByOwner(class_1297 entity) {
        return entity instanceof class_8046 ownable && owner != null && owner.equals(ownable.method_24921());
    }

    private boolean isComingFromAboveOrBelow(class_1297 entity) {
        return entity.method_23318() > (method_23318() + getVeilVisibleRadius() + 0.25) || entity.method_23320() < (method_23318() - 0.25);
    }

    private boolean isInside(class_1297 entity) {
        return entity.method_19538().method_1025(method_19538()) <= Math.pow(getVeilVisibleRadius(), 2);
    }

    private boolean isOnTheEdge(class_1297 entity) {
        return entity.method_19538().method_1025(method_19538()) <= Math.pow(getRadius(), 2);
    }

    @Override
    public boolean method_5696() {
        return true;
    }

    public final float getRadius() {
        return field_6011.method_12789(RADIUS);
    }

    public final void setRadius(float radius) {
        Preconditions.checkArgument(radius >= 2 && radius <= 4, "Veil radius cannot be smaller than 2 or greater than 4");
        field_6011.method_12778(RADIUS, radius);
    }

    public final float getVeilVisibleRadius() {
        return getRadius() - SCREENS_OFFSET;
    }

    @Nullable
    @Override
    public class_1657 method_24921() {
        return owner;
    }

    public int getLifeExpectancy() {
        return lifeExpectancy;
    }

    private class_4048 getDimensions() {
        return class_4048.method_18384(getRadius() * 2, getRadius() * 2);
    }

    @Override
    public class_4048 method_18377(class_4050 pose) {
        return getDimensions();
    }

    @Override
    protected class_238 method_33332() {
        return getDimensions().method_30757(method_19538());
    }

    @Override
    protected void method_5749(class_2487 nbt) {
        if (nbt.method_10573("radius", class_2520.field_33255)) {
            setRadius(nbt.method_10583("radius"));
        }
        if (nbt.method_10573("age", class_2520.field_33253)) {
            field_6012 = nbt.method_10550("age");
        }
        if (nbt.method_10573("life_expectancy", class_2520.field_33253)) {
            lifeExpectancy = nbt.method_10550("life_expectancy");
        }
        if (nbt.method_10545("owner")) {
            class_4844.field_25122.decode(class_2509.field_11560, nbt.method_10580("owner"))
                    .resultOrPartial(class_156.method_29188("Could not decode a Player UUID of ", Wizcraft.LOGGER::error))
                    .ifPresent(pair -> owner = method_5770().method_18470(field_6021));
            if (owner != null && nbt.method_10545("controlling_stack")) {
                controllingStack = owner.method_31548().method_5438(nbt.method_10550("controlling_stack"));
                if (controllingStack.method_7960()) {
                    controllingStack = null;
                }
            }
        }
    }

    @Override
    protected void method_5652(class_2487 nbt) {
        nbt.method_10548("radius", getRadius());
        nbt.method_10569("age", field_6012);
        nbt.method_10569("life_expectancy", getLifeExpectancy());
        if (owner != null) {
            class_4844.field_25122.encodeStart(class_2509.field_11560, owner.method_5667()).ifSuccess(it -> nbt.method_10566("owner", it));
            if (controllingStack != null) {
                var slot = owner.method_31548().method_7395(controllingStack);
                if (slot >= 0) {
                    nbt.method_10569("controlling_stack", slot);
                } else {
                    controllingStack.method_57381(WizcraftComponents.ENERGY_VEIL_UUID);
                }
            }
        }
    }
}
