package falseresync.wizcraft.common.entity;

import falseresync.wizcraft.common.WizcraftSounds;
import falseresync.wizcraft.common.world.WizcraftWorld;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1668;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_3218;
import net.minecraft.class_3966;
import net.minecraft.class_7923;

public class StarProjectileEntity extends class_1668 {
    /**
     * So, a bit of an explanation. If I try to remove the entity on the same tick as the collision
     * EVERYTHING breaks. I have no idea why. I guess world is processing particles/sounds/etc weirdly.
     * I couldn't find any reason as to why Dragon can do it on the same tick, but I don't
     * Explanations in a GitHub issue are welcome, if someone sees this rant.
     */
//    protected boolean shouldDiscardNextTick = false;
    public StarProjectileEntity(class_1299<StarProjectileEntity> entityType, class_1937 world) {
        super(entityType, world);
    }

    public StarProjectileEntity(class_1309 owner, class_1937 world) {
        this(WizcraftEntities.STAR_PROJECTILE, world);
        method_7432(owner);
        var rotation = owner.method_5828(1);
        var orthogonalDistance = 1;
        method_5814(owner.method_23317() + rotation.field_1352 * orthogonalDistance, owner.method_23320(), owner.method_23321() + rotation.field_1350 * orthogonalDistance);
        method_24919(owner, owner.method_36455(), owner.method_36454(), 0, 1.5F, 1F);
    }

    @Override
    protected boolean method_7468() {
        return false;
    }

    @Override
    protected class_2394 method_7467() {
        return class_2398.field_29644;
    }

    @Override
    public void method_5773() {
        super.method_5773();
        if (!method_37908().field_9236 && method_5805() && method_24921() != null && method_18798().method_1027() < 0.25) {
            explode();
        }
    }

    @Override
    protected void method_7454(class_3966 entityHitResult) {
        super.method_7454(entityHitResult);
        if (!method_37908().field_9236) {
            var target = entityHitResult.method_17782();
            var owner = method_24921();
            var source = method_48923().method_48815(this, owner);
            target.method_5643(source, 1.5F);
            class_1890.method_60107((class_3218) method_37908(), target, source);
        }
    }

    @Override
    protected void method_7488(class_239 hitResult) {
        super.method_7488(hitResult);
        if (!method_37908().field_9236) {
            explode();
        }
    }

    protected void explode() {
        method_37908().method_8454(
                this, method_48923().method_48815(this, method_24921()),
                WizcraftWorld.MagicDischargeExplosionBehavior.INSTANCE,
                method_23317(), method_23318(), method_23321(), 1f, false, class_1937.class_7867.field_40888,
                class_2398.field_11240, class_2398.field_11221, class_7923.field_41172.method_47983(WizcraftSounds.STAR_PROJECTILE_EXPLODE));
        method_31472();
    }
}
