package falseresync.wizcraft.common.item;

import falseresync.wizcraft.common.block.WizcraftBlockTags;
import falseresync.wizcraft.common.block.WizcraftBlocks;
import falseresync.wizcraft.common.block.WorktableVariant;
import falseresync.wizcraft.networking.s2c.TriggerBlockPatternTipS2CPayload;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1269;
import net.minecraft.class_1838;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import java.util.Comparator;

public interface ActivatorItem {
    Object2ObjectMap<class_2248, ActivationBehavior> ANY_BEHAVIORS = new Object2ObjectArrayMap<>();
    Object2ObjectMap<class_2248, ActivationBehavior> WAND_BEHAVIORS = new Object2ObjectArrayMap<>();

    static void registerBehaviors() {
        ANY_BEHAVIORS.put(class_2246.field_27097, context -> {
            var player = context.method_8036();
            if (player == null || player.method_7325()) return class_1269.field_5811;

            var world = context.method_8045();
            var pos = context.method_8037();
            if (world.method_8320(pos.method_10074()).method_26164(WizcraftBlockTags.CRUCIBLE_HEAT_SOURCES)) {
                if (world.field_9236) return class_1269.field_21466;

                world.method_8652(pos, WizcraftBlocks.CRUCIBLE.method_9564(), class_2248.field_31036);
                return class_1269.field_5812;
            } else {
                return class_1269.field_5814;
            }
        });

        WAND_BEHAVIORS.putAll(ANY_BEHAVIORS);
        WAND_BEHAVIORS.put(WizcraftBlocks.DUMMY_WORKTABLE, context -> {
            var player = context.method_8036();
            if (player == null || player.method_7325()) return class_1269.field_5811;

            var world = context.method_8045();
            if (world.field_9236) return class_1269.field_21466;

            var pos = context.method_8037();
            var serverPlayer = (class_3222) player;
            var matchedVariants = WorktableVariant.getForPlayerAndSearchAround((class_3218) world, serverPlayer, pos);
            var fullyCompletedVariant = matchedVariants.stream()
                    .filter(variant -> variant.match().isCompleted())
                    .findFirst();
            if (fullyCompletedVariant.isPresent()) {
                world.method_8501(pos, fullyCompletedVariant.get().block().method_9564());
                return class_1269.field_5812;
            }

            var leastUncompletedVariant = matchedVariants.stream()
                    .filter(variant -> variant.match().isHalfwayCompleted())
                    .max(Comparator.comparingInt(variant -> variant.match().size()));
//                    .min(Comparator.comparingInt(variant -> variant.match().delta().size()));
            if (leastUncompletedVariant.isPresent()) {
                ServerPlayNetworking.send(serverPlayer, new TriggerBlockPatternTipS2CPayload(leastUncompletedVariant.get().match().deltaAsBlockPos()));
                player.method_17356(class_3417.field_14962, class_3419.field_15245, 1f, 1f);
                player.method_7353(class_2561.method_43471("hud.wizcraft.worktable.incomplete_worktable"), true);

                return class_1269.field_5814;
            }

            return class_1269.field_5811;
        });
    }

    default class_1269 activateBlock(Object2ObjectMap<class_2248, ActivationBehavior> behaviors, class_1838 context) {
        var world = context.method_8045();
        var pos = context.method_8037();
        var state = world.method_8320(pos);
        var behavior = behaviors.get(state.method_26204());
        if (behavior != null) {
            return behavior.activateBlock(context);
        }

        return class_1269.field_5811;
    }

    @FunctionalInterface
    interface ActivationBehavior {
        class_1269 activateBlock(class_1838 context);
    }
}
