package falseresync.wizcraft.common.item;

import falseresync.wizcraft.common.Reports;
import falseresync.wizcraft.common.data.WizcraftAttachments;
import falseresync.wizcraft.common.data.WizcraftComponents;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_3222;
import net.minecraft.class_3417;

public class ChargeShellItem extends class_1792 {
    public static final int DEFAULT_CAPACITY = 100;

    public ChargeShellItem(class_1793 settings) {
        super(settings.method_57349(WizcraftComponents.SHELL_CAPACITY, DEFAULT_CAPACITY));
    }

    @Override
    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        var stack = user.method_5998(hand);
        var chargeShells = user.getAttached(WizcraftAttachments.CHARGE_SHELLS);
        if (chargeShells == null || chargeShells.canAddShell(DEFAULT_CAPACITY)) {
            user.method_6019(hand);
            return class_1271.method_22428(stack);
        }
        return super.method_7836(world, user, hand);
    }

    @Override
    public int method_7881(class_1799 stack, class_1309 user) {
        return 20;
    }

    @Override
    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8946;
    }

    @Override
    public class_1799 method_7861(class_1799 stack, class_1937 world, class_1309 user) {
        if (user instanceof class_3222 player) {
            var capacity = stack.method_57825(WizcraftComponents.SHELL_CAPACITY, DEFAULT_CAPACITY);
            var chargeShells = player.getAttachedOrCreate(WizcraftAttachments.CHARGE_SHELLS).withShell(capacity);
            if (chargeShells != null) {
                player.setAttached(WizcraftAttachments.CHARGE_SHELLS, chargeShells);
                Reports.playSoundToEveryone(player, class_3417.field_14698);
                return class_1799.field_8037;
            }
        }
        return super.method_7861(stack, world, user);
    }
}
