package falseresync.wizcraft.common.item;

import dev.emi.trinkets.api.TrinketItem;
import dev.emi.trinkets.api.TrinketsApi;
import falseresync.wizcraft.common.data.InventoryComponentProvider;
import falseresync.wizcraft.common.data.WizcraftComponents;
import java.util.Optional;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_5536;
import net.minecraft.class_5632;

public class FocusesBeltItem extends TrinketItem implements InventoryComponentProvider {
    public static final int INVENTORY_SIZE = 12;

    public FocusesBeltItem(class_1793 settings) {
        super(settings);
    }

    @Override
    public boolean method_31565(class_1799 stack, class_1735 slot, class_5536 clickType, class_1657 player) {
        if (clickType == class_5536.field_27014) {
            var remainder = exchangeStack(stack, slot.method_7677());
            if (remainder.method_5467().method_23665()) {
                slot.method_53512(remainder.method_5466());
                return true;
            }
        }
        return super.method_31565(stack, slot, clickType, player);
    }

    public Optional<class_1799> findTrinketStack(class_1657 player) {
        return TrinketsApi.getTrinketComponent(player)
                .map(trinketComponent -> trinketComponent.getEquipped(WizcraftItems.FOCUSES_BELT))
                .flatMap(equipped -> equipped.isEmpty() ? Optional.empty() : Optional.of(equipped.getFirst().method_15441()));
    }

    public class_1271<class_1799> exchangeStack(class_1799 beltStack, class_1799 stackInSlot) {
        var inventory = getOrCreateInventoryComponent(beltStack).toModifiable();
        var remainder = class_1799.field_8037;
        var dirty = false;
        if (stackInSlot.method_31573(WizcraftItemTags.FOCUSES)) {
            remainder = inventory.method_5491(stackInSlot);
            dirty = true;
        } else if (stackInSlot.method_7960()) {
            for (int i = 0; i < inventory.method_5439(); i++) {
                if (!inventory.method_5438(i).method_7960()) {
                    remainder = inventory.method_5441(i);
                    dirty = true;
                    break;
                }
            }
        }
        if (dirty) {
            inventory.flush(beltStack);
            return class_1271.method_22427(remainder);
        }
        return class_1271.method_22431(remainder);
    }

    @Override
    public Optional<class_5632> method_32346(class_1799 stack) {
        return Optional.ofNullable(stack.method_57824(WizcraftComponents.INVENTORY));
    }

    @Override
    public int getDefaultInventorySize() {
        return INVENTORY_SIZE;
    }
}
