package falseresync.wizcraft.common.item;

import falseresync.wizcraft.client.WizcraftKeybindings;
import falseresync.wizcraft.common.Wizcraft;
import falseresync.wizcraft.common.data.WizcraftComponents;
import falseresync.wizcraft.common.item.focus.FocusItem;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_5536;
import java.util.List;

public class WandItem extends class_1792 implements ActivatorItem {
    public WandItem(class_1793 settings) {
        super(settings
                .method_57349(WizcraftComponents.WAND_CHARGE, 0)
                .method_57349(WizcraftComponents.WAND_MAX_CHARGE, 100));
    }

    // Wand as an item

    @Override
    public boolean method_7885(class_2680 state, class_1937 world, class_2338 pos, class_1657 miner) {
        return false;
    }

    @Override
    public boolean method_31565(class_1799 wandStack, class_1735 slot, class_5536 clickType, class_1657 player) {
        if (clickType == class_5536.field_27014) {
            var exchange = exchangeFocuses(wandStack, slot.method_7677().method_7972(), player);
            if (exchange.method_5467().method_23665()) {
                slot.method_53512(exchange.method_5466());
                return true;
            }
        }
        return super.method_31565(wandStack, slot, clickType, player);
    }

    @Override
    public void method_7860(class_1799 stack) {
        var charge = stack.method_57825(WizcraftComponents.WAND_CHARGE, 0);
        var maxCharge = stack.method_57825(WizcraftComponents.WAND_MAX_CHARGE, 0);
        if (charge > maxCharge) {
            stack.method_57379(WizcraftComponents.WAND_CHARGE, maxCharge);
        }
    }

    @Override
    public boolean allowComponentsUpdateAnimation(class_1657 player, class_1268 hand, class_1799 oldStack, class_1799 newStack) {
        return false;
    }

    // Focus actions processing

    @Override
    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        var wandStack = user.method_5998(hand);
        var focusStack = getEquipped(wandStack);
        if (!focusStack.method_7960() && focusStack.method_7909() instanceof FocusItem focusItem) {
            return focusItem.focusUse(wandStack, focusStack, world, user, hand);
        }

        return super.method_7836(world, user, hand);
    }

    @Override
    public class_1269 method_7884(class_1838 context) {
        var activationResult = activateBlock(WAND_BEHAVIORS, context);
        if (activationResult.method_23665()) return activationResult;

        var wandStack = context.method_8041();
        var focusStack = getEquipped(wandStack);
        if (!focusStack.method_7960() && focusStack.method_7909() instanceof FocusItem focusItem) {
            return focusItem.focusUseOn(wandStack, focusStack, context);
        }

        return super.method_7884(context);
    }

    @Override
    public class_1269 method_7847(class_1799 stack, class_1657 user, class_1309 entity, class_1268 hand) {
        var wandStack = user.method_5998(hand);
        var focusStack = getEquipped(wandStack);
        if (!focusStack.method_7960() && focusStack.method_7909() instanceof FocusItem focusItem) {
            return focusItem.focusInteractLivingEntity(wandStack, focusStack, user, entity, hand);
        }

        return super.method_7847(stack, user, entity, hand);
    }

    @Override
    public void method_7852(class_1937 level, class_1309 user, class_1799 stack, int remainingUseTicks) {
        var focusStack = getEquipped(stack);
        if (!focusStack.method_7960() && focusStack.method_7909() instanceof FocusItem focusItem) {
            focusItem.focusOnUseTick(level, user, stack, focusStack, remainingUseTicks);
            return;
        }

        super.method_7852(level, user, stack, remainingUseTicks);
    }

    @Override
    public class_1799 method_7861(class_1799 stack, class_1937 level, class_1309 user) {
        var focusStack = getEquipped(stack);
        if (!focusStack.method_7960() && focusStack.method_7909() instanceof FocusItem focusItem) {
            return focusItem.focusFinishUsingItem(stack, focusStack, level, user);
        }

        return super.method_7861(stack, level, user);
    }

    @Override
    public void method_7840(class_1799 stack, class_1937 level, class_1309 user, int remainingUseTicks) {
        var focusStack = getEquipped(stack);
        if (!focusStack.method_7960() && focusStack.method_7909() instanceof FocusItem focusItem) {
            focusItem.focusReleaseUsing(stack, focusStack, level, user, remainingUseTicks);
        }
    }

    @Override
    public void method_7888(class_1799 stack, class_1937 level, class_1297 entity, int slot, boolean selected) {
        var focusStack = getEquipped(stack);
        if (!focusStack.method_7960() && focusStack.method_7909() instanceof FocusItem focusItem) {
            focusItem.focusInventoryTick(stack, focusStack, level, entity, slot, selected);
        }
        if (entity instanceof class_3222 player) {
            Wizcraft.getChargeManager().tryChargeWandPassively(stack, level, player);
        }
    }


    // Focus properties processing

    @Override
    public boolean method_7838(class_1799 stack) {
        var focusStack = getEquipped(stack);
        if (!focusStack.method_7960() && focusStack.method_7909() instanceof FocusItem focusItem) {
            return focusItem.focusUseOnRelease(stack, focusStack);
        }

        return super.method_7838(stack);
    }

//    @Override
//    public UseAction getUseAction(ItemStack focusStack) {
//        return super.getUseAction(focusStack);
//    }

    @Override
    public int method_7881(class_1799 stack, class_1309 user) {
        var focusStack = getEquipped(stack);
        if (!focusStack.method_7960() && focusStack.method_7909() instanceof FocusItem focusItem) {
            return focusItem.focusGetUseDuration(stack, focusStack, user);
        }

        return super.method_7881(stack, user);
    }

    @Override
    public float method_58403(class_1297 target, float baseAttackDamage, class_1282 damageSource) {
        var weaponStack = damageSource.method_60948();
        if (weaponStack != null && weaponStack.method_7909() instanceof WandItem) {
            var focusStack = getEquipped(weaponStack);
            if (!focusStack.method_7960() && focusStack.method_7909() instanceof FocusItem focusItem) {
                return focusItem.focusGetAttackDamageBonus(weaponStack, focusStack, target, baseAttackDamage, damageSource);
            }
        }

        return super.method_58403(target, baseAttackDamage, damageSource);
    }

    // Focus appearance processing

    @Override
    public boolean method_31567(class_1799 stack) {
        var focusStack = getEquipped(stack);
        if (!focusStack.method_7960() && focusStack.method_7909() instanceof FocusItem focusItem) {
            return focusItem.focusIsBarVisible(stack, focusStack);
        }

        return super.method_31567(stack);
    }

    @Override
    public int method_31569(class_1799 stack) {
        var focusStack = getEquipped(stack);
        if (!focusStack.method_7960() && focusStack.method_7909() instanceof FocusItem focusItem) {
            return focusItem.focusGetBarWidth(stack, focusStack);
        }

        return super.method_31569(stack);
    }

    @Override
    public int method_31571(class_1799 stack) {
        var focusStack = getEquipped(stack);
        if (!focusStack.method_7960() && focusStack.method_7909() instanceof FocusItem focusItem) {
            return focusItem.focusGetBarColor(stack, focusStack);
        }

        return super.method_31571(stack);
    }

    @Override
    public boolean method_7886(class_1799 stack) {
        var focusStack = getEquipped(stack);
        if (!focusStack.method_7960() && focusStack.method_7909() instanceof FocusItem focusItem) {
            return focusItem.focusIsFoil(stack, focusStack);
        }

        return super.method_7886(stack);
    }

    @Override
    public void method_7851(class_1799 stack, class_9635 context, List<class_2561> tooltip, class_1836 type) {
        var focusStack = getEquipped(stack);
        if (!focusStack.method_7960() && focusStack.method_7909() instanceof FocusItem focusItem) {
            tooltip.add(class_2561
                    .method_43469("tooltip.wizcraft.wand.active_focus", focusStack.method_7964())
                    .method_27694(style -> style.method_10977(class_124.field_1080)));
            focusItem.focusAppendHoverText(stack, focusStack, context, tooltip, type);
        }
        tooltip.add(class_2561
                .method_43469("tooltip.wizcraft.wand.change_focus", KeyBindingHelper.getBoundKeyOf(WizcraftKeybindings.TOOL_CONTROL).method_27445())
                .method_27694(style -> style.method_10977(class_124.field_1080).method_10978(true)));
        super.method_7851(stack, context, tooltip, type);
    }


    // Custom wand methods

    public class_1271<class_1799> exchangeFocuses(class_1799 wandStack, class_1799 newFocusStack, class_1657 user) {
        var oldFocusStack = getEquipped(wandStack);

        var removeOld = false;
        var insertNew = false;

        // newFocus = empty, oldFocus = empty -> pass newFocus
        if (newFocusStack.method_7960() && oldFocusStack.method_7960()) {
            return class_1271.method_22430(newFocusStack);
        }

        if (oldFocusStack.method_7909() instanceof FocusItem oldFocusItem) {
            removeOld = true;
            oldFocusItem.focusOnUnequipped(wandStack, oldFocusStack, user);
        }

        if (newFocusStack.method_7909() instanceof FocusItem newFocusItem) {
            insertNew = true;
            newFocusItem.focusOnEquipped(wandStack, newFocusStack, user);
        }

        // newFocus != empty, oldFocus == empty -> success oldFocus
        // newFocus != empty, oldFocus != empty -> success oldFocus
        if (insertNew) {
            wandStack.method_57379(WizcraftComponents.EQUIPPED_FOCUS_ITEM, newFocusStack);
            return class_1271.method_22427(oldFocusStack);
        }

        // newFocus = empty, oldFocus != empty -> success oldFocus
        if (removeOld) {
            wandStack.method_57381(WizcraftComponents.EQUIPPED_FOCUS_ITEM);
            return class_1271.method_22427(oldFocusStack);
        }

        // newFocus is not empty, but not a focus item -> fail newFocus
        return class_1271.method_22431(newFocusStack);
    }

    public class_1799 getEquipped(class_1799 wandStack) {
        return wandStack.method_57825(WizcraftComponents.EQUIPPED_FOCUS_ITEM, class_1799.field_8037);
    }
}
