package falseresync.wizcraft.common.item.focus;

import falseresync.wizcraft.common.Reports;
import falseresync.wizcraft.common.Wizcraft;
import falseresync.wizcraft.common.WizcraftSounds;
import falseresync.wizcraft.common.WizcraftUtil;
import falseresync.wizcraft.common.data.WizcraftComponents;
import falseresync.wizcraft.common.item.WizcraftItems;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5253;

public class ChargingFocusItem extends FocusItem {
    public ChargingFocusItem(class_1793 settings) {
        super(settings);
    }

    @Override
    public class_1271<class_1799> focusUse(class_1799 wandStack, class_1799 focusStack, class_1937 world, class_1657 user, class_1268 hand) {
        if (user instanceof class_3222 player) {
            if (Wizcraft.getChargeManager().calculateEnvironmentCoefficient(world, player) <= 0.25f
                    || user.method_5745(WizcraftUtil.findViewDistance(world) * 16, 0, true).method_17783() != class_239.class_240.field_1333) {
                player.method_17356(class_3417.field_14962, class_3419.field_15248, 1.0F, 1.0F);
                player.method_7353(class_2561.method_43471("hud.wizcraft.wand.cannot_charge"), true);
                return class_1271.method_22431(wandStack);
            }

            if (Wizcraft.getChargeManager().cannotAddAnyCharge(wandStack, player)) {
                player.method_17356(class_3417.field_26982, class_3419.field_15248, 1.0F, 1.0F);
                player.method_7353(class_2561.method_43471("hud.wizcraft.wand.already_charged"), true);
                return class_1271.method_22430(wandStack);
            }

            user.method_6019(user.method_6058());
            wandStack.method_57379(WizcraftComponents.CHARGING_FOCUS_PROGRESS, 0);
            return class_1271.method_22428(wandStack);
        }
        return super.focusUse(wandStack, focusStack, world, user, hand);
    }

    @Override
    public void focusOnUseTick(class_1937 world, class_1309 user, class_1799 wandStack, class_1799 focusStack, int remainingUseTicks) {
        wandStack.method_57368(WizcraftComponents.CHARGING_FOCUS_PROGRESS, 0, current -> current + 1);
    }

    @Override
    public void focusReleaseUsing(class_1799 wandStack, class_1799 focusStack, class_1937 world, class_1309 user, int remainingUseTicks) {
        wandStack.method_57381(WizcraftComponents.CHARGING_FOCUS_PROGRESS);
    }

    @Override
    public class_1799 focusFinishUsingItem(class_1799 wandStack, class_1799 focusStack, class_1937 world, class_1309 user) {
        wandStack.method_57381(WizcraftComponents.CHARGING_FOCUS_PROGRESS);
        if (user instanceof class_3222 player) {
            var amount = (int) (30 * Wizcraft.getChargeManager().calculateEnvironmentCoefficient(world, player));
            Wizcraft.getChargeManager().chargeWand(wandStack, amount, player);
            focusStack.method_7970(1, player, class_1304.field_6173);

            Reports.playSoundToEveryone(player, WizcraftSounds.SUCCESSFULLY_CHARGED);
            player.method_7353(class_2561.method_43471("hud.wizcraft.wand.successfully_charged").method_27694(style -> style.method_10977(class_124.field_1065)), true);
            var rotation = player.method_5828(1);
            var orthogonalDistance = 1;
            var sourcePos = player.method_33571()
                    .method_1019(player.method_40123(WizcraftItems.WAND))
                    .method_1031(rotation.field_1352 * orthogonalDistance, -0.25, rotation.field_1350 * orthogonalDistance);
            Reports.addSparkles(world, sourcePos);
        }
        return wandStack;
    }

    @Override
    public int focusGetUseDuration(class_1799 wandStack, class_1799 focusStack, class_1309 user) {
        return 50;
    }

    @Override
    public boolean focusIsBarVisible(class_1799 wandStack, class_1799 focusStack) {
        return wandStack.method_57825(WizcraftComponents.CHARGING_FOCUS_PROGRESS, 0) > 0;
    }

    @Override
    public int focusGetBarWidth(class_1799 wandStack, class_1799 focusStack) {
        return Math.round(wandStack.method_57825(WizcraftComponents.CHARGING_FOCUS_PROGRESS, 0) * 13f / focusGetUseDuration(wandStack, focusStack, null));
    }

    @Override
    public int focusGetBarColor(class_1799 wandStack, class_1799 focusStack) {
        return class_5253.class_5254.method_27764(0, 115, 190, 211);
    }
}
