package falseresync.wizcraft.common.item.focus;

import falseresync.wizcraft.common.Reports;
import falseresync.wizcraft.common.Wizcraft;
import falseresync.wizcraft.common.WizcraftSounds;
import falseresync.wizcraft.common.data.WizcraftComponents;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2694;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_4208;
import net.minecraft.class_4550;
import net.minecraft.class_5454;
import net.minecraft.class_6538;
import net.minecraft.class_9334;

public class CometWarpFocusItem extends FocusItem {
    public static final class_6538 LODESTONE_CHECKER = new class_6538(List.of(
            class_4550.class_4710.method_23880()
                    .method_27962(class_2246.field_23261)
                    .method_23882()
    ), false);
    public static final int DEFAULT_PLACEMENT_COST = 5;
    public static final int DEFAULT_WARPING_COST = 15;
    public static final int DEFAULT_INTERDIMENSIONAL_COST = 30;
    public static final int PERSISTENT_ANCHOR_COST_COEFFICIENT = 2;

    public CometWarpFocusItem(class_1793 settings) {
        super(settings.method_57349(class_9334.field_49634, LODESTONE_CHECKER));
    }

    private static void reportPermanentlyBound(class_1657 player, class_4208 permanentAnchor) {
        player.method_7353(class_2561.method_43469("hud.wizcraft.focus.comet_warp.permanently_anchored", permanentAnchor.comp_2207().method_29177().method_12832(), permanentAnchor.comp_2208().method_23854()), true);
    }

    private static void appendTooltip$internal(class_1799 wandStack, class_1799 focusStack, class_9635 context, List<class_2561> tooltip, class_1836 type, boolean showSetupTip) {
        if (focusStack.method_57826(WizcraftComponents.TOOLTIP_OVERRIDDEN)) {
            return;
        }

        var anchor = wandStack.method_57824(WizcraftComponents.WARP_FOCUS_ANCHOR);
        if (anchor != null) {
            tooltip.add(class_2561.method_43469(
                            "tooltip.wizcraft.wand.has_anchor",
                            anchor.comp_2207().method_29177().method_12832(),
                            anchor.comp_2208().method_23854())
                    .method_27692(class_124.field_1080));
        }

        var persistentAnchor = wandStack.method_57824(WizcraftComponents.WARP_FOCUS_PERSISTENT_ANCHOR);
        if (persistentAnchor != null) {
            var key = focusStack.method_57826(WizcraftComponents.WARP_FOCUS_BLOCK_ONLY_MODE)
                    ? "tooltip.wizcraft.wand.has_anchor"
                    : "tooltip.wizcraft.wand.has_permanent_anchor";
            tooltip.add(class_2561.method_43469(
                            key,
                            persistentAnchor.comp_2207().method_29177().method_12832(),
                            persistentAnchor.comp_2208().method_23854())
                    .method_27692(class_124.field_1080));
        }

        if (anchor == null && persistentAnchor == null && showSetupTip) {
            tooltip.add(class_2561.method_43471("tooltip.wizcraft.wand.setup_anchor").method_27692(class_124.field_1080));
        }
    }

    @Override
    public void focusOnEquipped(class_1799 wandStack, class_1799 focusStack, class_1657 user) {
        transferComponent(focusStack, wandStack, WizcraftComponents.WARP_FOCUS_ANCHOR);
        transferComponent(focusStack, wandStack, WizcraftComponents.WARP_FOCUS_PERSISTENT_ANCHOR);
    }

    @Override
    public void focusOnUnequipped(class_1799 wandStack, class_1799 focusStack, class_1657 user) {
        transferComponent(wandStack, focusStack, WizcraftComponents.WARP_FOCUS_ANCHOR);
        transferComponent(wandStack, focusStack, WizcraftComponents.WARP_FOCUS_PERSISTENT_ANCHOR);
    }

    @Override
    public class_1269 focusUseOn(class_1799 wandStack, class_1799 focusStack, class_1838 context) {
        var world = context.method_8045();
        var player = context.method_8036();
        if (player == null) {
            return class_1269.field_5811;
        }

        // Do not override lodestones
        var persistentAnchor = wandStack.method_57824(WizcraftComponents.WARP_FOCUS_PERSISTENT_ANCHOR);
        if (persistentAnchor != null && !focusStack.method_57826(WizcraftComponents.WARP_FOCUS_BLOCK_ONLY_MODE)) {
            if (world.field_9236 && player.method_5715()) {
                reportPermanentlyBound(player, persistentAnchor);
            }
            return class_1269.field_5811;
        }

        var pos = context.method_8037();
        if (focusStack.method_57357(new class_2694(world, pos, false))) {
            if (!world.field_9236 && player.method_5715()) {
                if (!Wizcraft.getChargeManager().tryExpendWandCharge(wandStack, DEFAULT_PLACEMENT_COST * PERSISTENT_ANCHOR_COST_COEFFICIENT, player)) {
                    Reports.insufficientCharge(player);
                    return class_1269.field_5814;
                }

                player.method_17356(class_3417.field_23199, class_3419.field_15248, 1f, 1f);
                wandStack.method_57379(WizcraftComponents.WARP_FOCUS_PERSISTENT_ANCHOR, class_4208.method_19443(world.method_27983(), pos.method_10084()));
                wandStack.method_57381(WizcraftComponents.WARP_FOCUS_ANCHOR);
                focusStack.method_7970(1, player, class_1304.field_6173);
                return class_1269.field_5812;
            }

            return class_1269.field_21466;
        } else if (focusStack.method_57826(WizcraftComponents.WARP_FOCUS_BLOCK_ONLY_MODE)) {
            if (world.field_9236) {
                player.method_7353(class_2561.method_43471("hud.wizcraft.focus.comet_warp.cannot_anchor_here"), true);
            }
            return class_1269.field_5814;
        }

        return super.focusUseOn(wandStack, focusStack, context);
    }

    @Override
    public class_1271<class_1799> focusUse(class_1799 wandStack, class_1799 focusStack, class_1937 world, class_1657 user, class_1268 hand) {
        if (user instanceof class_3222 player && world instanceof class_3218 serverWorld) {
            if (user.method_5715()) {
                // Do not override lodestones
                var persistentAnchor = wandStack.method_57824(WizcraftComponents.WARP_FOCUS_PERSISTENT_ANCHOR);
                if (persistentAnchor != null) {
                    if (!focusStack.method_57826(WizcraftComponents.WARP_FOCUS_BLOCK_ONLY_MODE)) {
                        reportPermanentlyBound(player, persistentAnchor);
                    }
                    return class_1271.method_22431(wandStack);
                }

                if (!Wizcraft.getChargeManager().tryExpendWandCharge(wandStack, DEFAULT_PLACEMENT_COST, user)) {
                    Reports.insufficientCharge(player);
                    return class_1271.method_22431(wandStack);
                }

                Reports.playSoundToEveryone(player, WizcraftSounds.COMET_WARP_ANCHOR_PLACED);
                wandStack.method_57379(WizcraftComponents.WARP_FOCUS_ANCHOR, class_4208.method_19443(world.method_27983(), user.method_24515()));
                if (world.field_9229.method_43057() < 0.1f) {
                    focusStack.method_7970(1, player, class_1304.field_6173);
                }
            } else {
                var anchor = wandStack.method_57824(WizcraftComponents.WARP_FOCUS_ANCHOR);
                var persistent = false;
                if (anchor == null) {
                    anchor = wandStack.method_57824(WizcraftComponents.WARP_FOCUS_PERSISTENT_ANCHOR);
                    persistent = true;
                }

                if (anchor == null) {
                    player.method_17356(class_3417.field_14962, class_3419.field_15248, 1f, 1f);
                    player.method_7353(class_2561.method_43471("hud.wizcraft.focus.comet_warp.no_anchor"), true);
                    return class_1271.method_22431(wandStack);
                }

                var destination = serverWorld.method_8503().method_3847(anchor.comp_2207());
                if (destination == null) {
                    // Broken anchor
                    player.method_17356(class_3417.field_15239, class_3419.field_15248, 1f, 1f);
                    wandStack.method_57381(WizcraftComponents.WARP_FOCUS_ANCHOR);
                    wandStack.method_57381(WizcraftComponents.WARP_FOCUS_PERSISTENT_ANCHOR);
                    return class_1271.method_22431(wandStack);
                }

                int warpingCost = destination.method_8597() != world.method_8597() ? DEFAULT_INTERDIMENSIONAL_COST : DEFAULT_WARPING_COST;
                if (persistent) {
                    warpingCost /= PERSISTENT_ANCHOR_COST_COEFFICIENT;
                }

                if (!Wizcraft.getChargeManager().tryExpendWandCharge(wandStack, warpingCost, user)) {
                    Reports.insufficientCharge(player);
                    return class_1271.method_22431(wandStack);
                }

                Reports.playSoundToEveryone(player, class_3417.field_46945);
                user.method_5731(new class_5454(destination, anchor.comp_2208().method_46558(), class_243.field_1353, user.method_36454(), user.method_36455(), class_5454.field_52245));
                if (!persistent) {
                    wandStack.method_57381(WizcraftComponents.WARP_FOCUS_ANCHOR);
                }
                focusStack.method_7970(1, player, class_1304.field_6173);
            }
            return class_1271.method_22427(wandStack);
        }

        return class_1271.method_22428(wandStack);
    }

    @Override
    public boolean focusIsFoil(class_1799 wandStack, class_1799 focusStack) {
        return method_7886(wandStack);
    }

    @Override
    public void focusAppendHoverText(class_1799 wandStack, class_1799 focusStack, class_9635 context, List<class_2561> tooltip, class_1836 type) {
        appendTooltip$internal(wandStack, focusStack, context, tooltip, type, true);
    }

    @Override
    public boolean method_7886(class_1799 stack) {
        return stack.method_57826(WizcraftComponents.WARP_FOCUS_ANCHOR) || stack.method_57826(WizcraftComponents.WARP_FOCUS_PERSISTENT_ANCHOR);
    }

    @Override
    public void method_7851(class_1799 stack, class_9635 context, List<class_2561> tooltip, class_1836 type) {
        appendTooltip$internal(stack, stack, context, tooltip, type, false);
    }
}
