package falseresync.wizcraft.common.item.focus;

import falseresync.wizcraft.common.Reports;
import falseresync.wizcraft.common.Wizcraft;
import falseresync.wizcraft.common.WizcraftSounds;
import falseresync.wizcraft.common.WizcraftUtil;
import falseresync.wizcraft.common.data.ItemBarComponent;
import falseresync.wizcraft.common.data.WizcraftAttachments;
import falseresync.wizcraft.common.data.WizcraftComponents;
import falseresync.wizcraft.common.entity.EnergyVeilEntity;
import falseresync.wizcraft.common.world.WizcraftWorld;
import io.wispforest.owo.ui.core.Color;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2398;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3730;
import net.minecraft.class_5253;
import net.minecraft.class_7923;

public class EnergyVeilFocusItem extends FocusItem {
    public static final int USE_DURATION = 200;
    public static final int STARTING_COST = 10;
    public static final int CONTINUOUS_COST = 2;
    private static final int CYAN_ARGB = class_5253.class_5254.method_27764(0, 115, 190, 211);
    private static final Color CYAN = Color.ofArgb(CYAN_ARGB);
    private static final Color RED = Color.ofHsv(2 / 360F, 1F, 0.8F);

    public EnergyVeilFocusItem(class_1793 settings) {
        super(settings);
    }

    @Override
    public void focusOnEquipped(class_1799 wandStack, class_1799 focusStack, class_1657 user) {
        removeOrphanedVeilReference(wandStack, user);
    }

    @Override
    public void focusOnUnequipped(class_1799 wandStack, class_1799 focusStack, class_1657 user) {
        resetWand(wandStack);
    }

    @Override
    public class_1271<class_1799> focusUse(class_1799 wandStack, class_1799 focusStack, class_1937 level, class_1657 user, class_1268 hand) {
        removeOrphanedVeilReference(wandStack, user);
        if (user instanceof class_3222 player
                && !wandStack.method_57826(WizcraftComponents.ENERGY_VEIL_UUID)
                && !user.hasAttached(WizcraftAttachments.ENERGY_VEIL_NETWORK_ID)) {
            if (Wizcraft.getChargeManager().tryExpendWandCharge(wandStack, STARTING_COST, user)) {
                var veil = new EnergyVeilEntity(user, wandStack, level);
                veil.setRadius(2);
                level.method_8649(veil);
                wandStack.method_57379(WizcraftComponents.ENERGY_VEIL_UUID, veil.method_5667());
                wandStack.method_57379(WizcraftComponents.IN_USE, true);
                user.method_6019(user.method_6058());
                return class_1271.method_22427(wandStack);
            }

            Reports.insufficientCharge(player);
            return class_1271.method_22431(wandStack);
        }
        return class_1271.method_22430(wandStack);
    }

    @Override
    public void focusOnUseTick(class_1937 level, class_1309 user, class_1799 wandStack, class_1799 focusStack, int remainingUseTicks) {
        findVeil(wandStack, level).ifPresent(veil -> {
            if (user instanceof class_3222 player) {
                if (!Wizcraft.getChargeManager().tryExpendWandCharge(wandStack, CONTINUOUS_COST, player)) {
                    player.method_5643(level.method_48963().method_48831(), 0.1f);
                    var previousDeficit = wandStack.method_57368(WizcraftComponents.CHARGE_DEFICIT, 0, it -> it + CONTINUOUS_COST);
                    if (previousDeficit != null && previousDeficit % (CONTINUOUS_COST * 35) == 0) {
                        class_1299.field_6059.method_47821((class_3218) level, WizcraftUtil.fuzzyPos(level.field_9229, 1, player.method_24515()), class_3730.field_16461);
                    }
                    if (level.field_9229.method_43057() < 0.1f) {
                        focusStack.method_7970(1, user, class_1304.field_6173);
                    }
                }
                veil.incrementLifeExpectancy(2);
                var maxUseTicks = focusGetUseDuration(wandStack, focusStack, user);
                wandStack.method_57379(
                        WizcraftComponents.ITEM_BAR,
                        new ItemBarComponent(Math.clamp(Math.round((maxUseTicks - remainingUseTicks) * 13f / maxUseTicks), 0, 13), CYAN_ARGB));

                if (level.field_9229.method_43057() < 0.01f) {
                    focusStack.method_7970(1, user, class_1304.field_6173);
                }
            }
        });
    }

    @Override
    public void focusReleaseUsing(class_1799 wandStack, class_1799 focusStack, class_1937 world, class_1309 user, int remainingUseTicks) {
        focusFinishUsingItem(wandStack, focusStack, world, user);
    }

    @Override
    public class_1799 focusFinishUsingItem(class_1799 wandStack, class_1799 focusStack, class_1937 level, class_1309 user) {
        if (!level.field_9236) {
            Optional.ofNullable(wandStack.method_57824(WizcraftComponents.CHARGE_DEFICIT)).ifPresent(deficit -> {
                if (deficit > CONTINUOUS_COST * 50) {
                    // TODO: different sound
                    level.method_8454(
                            user, level.method_48963().method_48831(), WizcraftWorld.MagicDischargeExplosionBehavior.INSTANCE,
                            user.method_23317(), user.method_23318(), user.method_23321(), 3f, false, class_1937.class_7867.field_51779,
                            class_2398.field_29644, class_2398.field_11221, class_7923.field_41172.method_47983(WizcraftSounds.STAR_PROJECTILE_EXPLODE));
                }
            });
            resetWand(wandStack);
            focusStack.method_7970(1, user, class_1304.field_6173);
        }
        return wandStack;
    }

    @Override
    public int focusGetUseDuration(class_1799 wandStack, class_1799 focusStack, class_1309 user) {
        return USE_DURATION;
    }

    @Override
    public void focusInventoryTick(class_1799 wandStack, class_1799 focusStack, class_1937 level, class_1297 entity, int slot, boolean selected) {
        if (wandStack.method_57826(WizcraftComponents.IN_USE)) return;

        findVeil(wandStack, level).ifPresent(veil -> {
            float delta = Math.clamp(2f * (float) (veil.getLifeExpectancy() - veil.field_6012) / veil.getLifeExpectancy(), 0, 1);
            if (delta <= 1 / 13f) {
                wandStack.method_57381(WizcraftComponents.ITEM_BAR);
            } else {
                wandStack.method_57379(WizcraftComponents.ITEM_BAR, new ItemBarComponent(Math.clamp(Math.round(delta * 13f), 0, 13), RED.interpolate(CYAN, delta).argb()));
            }
        });
    }

    private void resetWand(class_1799 wandStack) {
        wandStack.method_57381(WizcraftComponents.IN_USE);
        wandStack.method_57381(WizcraftComponents.ITEM_BAR);
        wandStack.method_57381(WizcraftComponents.CHARGE_DEFICIT);
    }

    private Optional<EnergyVeilEntity> findVeil(class_1799 wandStack, class_1937 level) {
        if (level instanceof class_3218 serverLevel) {
            return Optional.ofNullable(wandStack.method_57824(WizcraftComponents.ENERGY_VEIL_UUID)).flatMap(uuid -> {
                if (serverLevel.method_14190(uuid) instanceof EnergyVeilEntity veil) {
                    return Optional.of(veil);
                }

                return Optional.empty();
            });
        }

        return Optional.empty();
    }

    // This has to happen on the server, and only when the component is present, and only in that order
    private void removeOrphanedVeilReference(class_1799 wandStack, class_1657 user) {
        if (user.method_37908() instanceof class_3218 serverLevel) {
            Optional.ofNullable(wandStack.method_57824(WizcraftComponents.ENERGY_VEIL_UUID)).ifPresent(uuid -> {
                if (!(serverLevel.method_14190(uuid) instanceof EnergyVeilEntity)) {
                    wandStack.method_57381(WizcraftComponents.ENERGY_VEIL_UUID);
                    user.removeAttached(WizcraftAttachments.ENERGY_VEIL_NETWORK_ID);
                }
            });
        }
    }
}
