package falseresync.wizcraft.common.item.focus;

import falseresync.wizcraft.common.Reports;
import falseresync.wizcraft.common.Wizcraft;
import falseresync.wizcraft.common.WizcraftUtil;
import falseresync.wizcraft.common.data.WizcraftAttachments;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;

public class LightningFocusItem extends FocusItem {
    public LightningFocusItem(class_1793 settings) {
        super(settings);
    }

    @Override
    public class_1271<class_1799> focusUse(class_1799 gadgetStack, class_1799 focusStack, class_1937 world, class_1657 user, class_1268 hand) {
        if (user instanceof class_3222 player) {
            if (Wizcraft.getChargeManager().tryExpendWandCharge(gadgetStack, 10, user)) {
                var lightning = class_1299.field_6112.method_5883(world);
                var maxDistance = class_3532.method_15363(WizcraftUtil.findViewDistance(world) * 16 / 4F, 32, 128);
                var raycastResult = user.method_5745(maxDistance, 0, true);
                var pos = raycastResult.method_17783() == class_239.class_240.field_1333
                        ? findGroundPos((class_3218) world, raycastResult.method_17784())
                        : raycastResult.method_17784();
                // There won't be an NPE, because lightnings are not optional features. Hopefully.
                //noinspection DataFlowIssue
                lightning.method_29495(pos);
                lightning.method_6961(player);
                lightning.setAttached(WizcraftAttachments.THUNDERLESS_LIGHTNING, true);
                world.method_8649(lightning);
                focusStack.method_7970(1, user, class_1304.field_6173);
                return class_1271.method_22427(gadgetStack);
            }

            Reports.insufficientCharge(player);
            return class_1271.method_22431(gadgetStack);
        }

        return class_1271.method_22428(gadgetStack);
    }

    protected class_243 findGroundPos(class_3218 world, class_243 posInAir) {
        return new class_243(
                posInAir.field_1352,
                world.method_8624(class_2902.class_2903.field_13197, (int) posInAir.field_1352, (int) posInAir.field_1350),
                posInAir.field_1350);
    }
}
