package falseresync.wizcraft.common.recipe;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredient;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredientSerializer;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2960;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import java.util.Arrays;
import java.util.List;

import static falseresync.wizcraft.common.Wizcraft.wid;

public record CountableIngredient(class_1856 vanilla, int count) implements CustomIngredient {
    @Override
    public boolean test(class_1799 stack) {
        return vanilla.method_8093(stack) && stack.method_7947() == count;
    }

    @Override
    public List<class_1799> getMatchingStacks() {
        return Arrays.asList(vanilla.method_8105());
    }

    @Override
    public boolean requiresTesting() {
        return true;
    }

    @Override
    public CustomIngredientSerializer<CountableIngredient> getSerializer() {
        return WizcraftCustomIngredients.COUNTABLE_INGREDIENT_SERIALIZER;
    }

    public static class Serializer implements CustomIngredientSerializer<CountableIngredient> {
        public static final class_2960 ID = wid("countable_ingredient");
        public static final MapCodec<CountableIngredient> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group(
                class_1856.field_46096.fieldOf("vanilla").forGetter(CountableIngredient::vanilla),
                Codec.INT.optionalFieldOf("count", 1).validate(amount -> {
                    if (amount < 1) {
                        return DataResult.error(() -> "A count of ingredient must not be lower than 1");
                    } else if (amount > 10) {
                        return DataResult.error(() -> "A count of ingredient must not be greater than 10");
                    } else {
                        return DataResult.success(amount);
                    }
                }).forGetter(CountableIngredient::count)
        ).apply(instance, CountableIngredient::new));
        public static final class_9139<class_9129, CountableIngredient> PACKET_CODEC = class_9139.method_56435(
                class_1856.field_48355, CountableIngredient::vanilla,
                class_9135.field_49675, CountableIngredient::count,
                CountableIngredient::new
        );

        @Override
        public class_2960 getIdentifier() {
            return ID;
        }

        @Override
        public MapCodec<CountableIngredient> getCodec(boolean allowEmpty) {
            return CODEC;
        }

        @Override
        public class_9139<class_9129, CountableIngredient> getPacketCodec() {
            return PACKET_CODEC;
        }
    }
}
