package falseresync.wizcraft.common.recipe;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import falseresync.wizcraft.common.CommonKeys;
import java.util.ArrayDeque;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_3956;
import net.minecraft.class_7225;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9695;

public final class LensedWorktableRecipe implements class_1860<class_9695> {
    private final class_1799 result;
    private final int craftingTime;
    private final class_1856 worktableInput;
    private final class_2371<class_1856> pedestalInputs;
    private final class_2371<class_1856> allIngredients;

    public LensedWorktableRecipe(class_1799 result, class_1856 worktableInput, class_2371<class_1856> pedestalInputs) {
        this(result, 100, worktableInput, pedestalInputs);
    }

    public LensedWorktableRecipe(class_1799 result, int craftingTime, class_1856 worktableInput, class_2371<class_1856> pedestalInputs) {
        this.result = result;
        this.craftingTime = craftingTime;
        this.worktableInput = worktableInput;
        this.pedestalInputs = pedestalInputs;
        this.allIngredients = class_2371.method_37434(pedestalInputs.size() + 1);
        this.allIngredients.add(worktableInput);
        this.allIngredients.addAll(pedestalInputs);
    }

    @Override
    public class_2371<class_1856> method_8117() {
        return allIngredients;
    }

    @Override
    public boolean method_8118() {
        return true;
    }

    @Override
    public boolean method_8115(class_9695 input, class_1937 world) {
        if (input.method_59983() < allIngredients.size()) {
            return false;
        }

        if (!worktableInput.method_8093(input.method_59984(0))) {
            return false;
        }

        var stacksInSlots = IntStream.rangeClosed(1, input.method_59983())
                .mapToObj(input::method_59984)
                .filter(stack -> !stack.method_7960())
                .collect(Collectors.toCollection(ArrayDeque::new));
        // These loops are meant to "rotate" the stacks around until they match pedestal inputs
        for (int i = 0; i < stacksInSlots.size(); i++) {
            var stacksMatchPedestals = true;
            for (var pedestalInput : this.pedestalInputs) {
                var currentStack = stacksInSlots.removeFirst();
                stacksInSlots.offerLast(currentStack);
                if (!pedestalInput.method_8093(currentStack)) {
                    stacksMatchPedestals = false;
                    break;
                }
            }
            if (stacksMatchPedestals) {
                return true;
            }
        }

        return false;
    }

    @Override
    public class_1799 method_8116(class_9695 input, class_7225.class_7874 lookup) {
        return method_8110(lookup);
    }

    @Override
    public boolean method_8113(int width, int height) {
        return width * height >= allIngredients.size();
    }

    @Override
    public class_1799 method_8110(class_7225.class_7874 registriesLookup) {
        return result.method_7972();
    }

    @Override
    public class_1865<LensedWorktableRecipe> method_8119() {
        return WizcraftRecipeSerializers.LENSED_WORKTABLE;
    }

    @Override
    public class_3956<LensedWorktableRecipe> method_17716() {
        return WizcraftRecipes.LENSED_WORKTABLE;
    }

    public class_1799 getResult() {
        return result;
    }

    public int getCraftingTime() {
        return craftingTime;
    }

    public class_1856 getWorktableInput() {
        return worktableInput;
    }

    public class_2371<class_1856> getPedestalInputs() {
        return pedestalInputs;
    }

    public static class Serializer implements class_1865<LensedWorktableRecipe> {
        public static final MapCodec<LensedWorktableRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group(
                class_1799.field_51397.fieldOf(CommonKeys.RESULT).forGetter(recipe -> recipe.result),
                Codec.INT.optionalFieldOf(CommonKeys.CRAFTING_TIME, 100)
                        .flatXmap(
                                craftingTime -> craftingTime < 30
                                        ? DataResult.error(() -> "Crafting time below 30 ticks is unsupported")
                                        : DataResult.success(craftingTime),
                                DataResult::success
                        )
                        .forGetter(recipe -> recipe.craftingTime),
                class_1856.field_46096.fieldOf(CommonKeys.WORKTABLE).forGetter(recipe -> recipe.worktableInput),
                class_1856.field_46096.listOf().fieldOf(CommonKeys.PEDESTALS)
                        .flatXmap(
                                ingredients -> {
                                    var nonEmptyIngredients = ingredients.stream().filter(ingredient -> !ingredient.method_8103()).toArray(class_1856[]::new);
                                    if (nonEmptyIngredients.length == 0) {
                                        return DataResult.error(() -> "No pedestal ingredients for a Lensed worktable recipe");
                                    } else {
                                        return nonEmptyIngredients.length > 4
                                                ? DataResult.error(() -> "Too many pedestal ingredients for a Lensed worktable recipe")
                                                : DataResult.success(class_2371.method_10212(class_1856.field_9017, nonEmptyIngredients));
                                    }
                                },
                                DataResult::success
                        )
                        .forGetter(recipe -> recipe.pedestalInputs)
        ).apply(instance, LensedWorktableRecipe::new));
        public static final class_9139<class_9129, LensedWorktableRecipe> PACKET_CODEC = class_9139.method_56905(
                class_1799.field_48349, recipe -> recipe.result,
                class_9135.field_49675, recipe -> recipe.craftingTime,
                class_1856.field_48355, recipe -> recipe.worktableInput,
                class_9135.method_56376(class_2371::method_37434, class_1856.field_48355), recipe -> recipe.pedestalInputs,
                LensedWorktableRecipe::new
        );

        @Override
        public MapCodec<LensedWorktableRecipe> method_53736() {
            return CODEC;
        }

        @Override
        public class_9139<class_9129, LensedWorktableRecipe> method_56104() {
            return PACKET_CODEC;
        }
    }
}
