package falseresync.wizcraft.compat.lavender;

import com.google.common.collect.ImmutableList;
import falseresync.wizcraft.common.recipe.CountableIngredient;
import io.wispforest.owo.ui.component.ItemComponent;
import io.wispforest.owo.ui.core.Insets;
import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_1856;

/**
 * @see io.wispforest.lavender.md.ItemListComponent
 */
public class CountableItemListComponent extends ItemComponent {
    private float time = 0f;
    private @Nullable ImmutableList<class_1799> items;
    private int currentStackIndex;

    protected CountableItemListComponent() {
        super(class_1799.field_8037);
        setTooltipFromStack(true);
        margins(Insets.bottom(4));
    }

    @Override
    public void update(float delta, int mouseX, int mouseY) {
        super.update(delta, mouseX, mouseY);

        time += delta;
        if (time >= 20) {
            time -= 20;
            updateForItems();
        }
    }

    public CountableItemListComponent countableIngredient(CountableIngredient ingredient) {
        items = ImmutableList.copyOf(ingredient.getMatchingStacks().stream()
                .map(it -> it.method_46651(ingredient.count()))
                .toList());
        updateForItems();
        showOverlay(true);

        return this;
    }

    public CountableItemListComponent ingredient(class_1856 ingredient) {
        items = ImmutableList.copyOf(ingredient.method_8105());
        updateForItems();

        return this;
    }

    private void updateForItems() {
        if (items != null && !items.isEmpty()) {
            currentStackIndex = (currentStackIndex + 1) % items.size();
            stack(items.get(currentStackIndex));
        } else {
            currentStackIndex = 0;
            stack(class_1799.field_8037);
        }
    }

}
