package falseresync.wizcraft.datagen;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import falseresync.wizcraft.common.block.WizcraftBlocks;
import falseresync.wizcraft.common.item.WizcraftItems;
import falseresync.wizcraft.common.item.focus.FocusItem;
import falseresync.wizcraft.common.item.focus.FocusPlating;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricModelProvider;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4915;
import net.minecraft.class_4925;
import net.minecraft.class_4935;
import net.minecraft.class_4936;
import net.minecraft.class_4941;
import net.minecraft.class_4942;
import net.minecraft.class_4943;
import net.minecraft.class_4944;
import net.minecraft.class_4945;
import net.minecraft.class_4946;
import java.util.Map;
import java.util.Optional;

import static falseresync.wizcraft.common.Wizcraft.wid;

public class WizcraftModelProvider extends FabricModelProvider {
    public static final class_4945 KEY_OVERLAY = class_4945.method_27043("overlay");
    public static final class_4942 MODEL_TEMPLATE_WORKTABLE =
            new class_4942(Optional.of(wid("block/template_worktable")), Optional.empty(), KEY_OVERLAY);
    public static final class_4946.class_4947 WORKTABLE =
            class_4946.method_25918(block -> new class_4944().method_25868(KEY_OVERLAY, class_4944.method_25866(block, "_overlay")), MODEL_TEMPLATE_WORKTABLE);

    public WizcraftModelProvider(FabricDataOutput output) {
        super(output);
    }

    private static void addWorktableVariant(class_4910 blockStateModelGenerator, class_2248 block) {
        blockStateModelGenerator.field_22830.accept(
                class_4925.method_25770(
                        block,
                        class_4935.method_25824().method_25828(
                                class_4936.field_22887,
                                WORKTABLE.method_25923(block, blockStateModelGenerator.field_22831))));
    }

    private static void addSimpleBlockWithoutItem(class_4910 blockStateModelGenerator, class_2248 block) {
        var blockModelId = class_4941.method_25842(block);
        blockStateModelGenerator.field_22830.accept(
                class_4925.method_25770(
                        block,
                        class_4935.method_25824().method_25828(class_4936.field_22887, blockModelId)));
        blockStateModelGenerator.method_25540(block);
    }

    private static void addSimpleBlock(class_4910 blockStateModelGenerator, class_2248 block) {
        var blockModelId = class_4941.method_25842(block);
        blockStateModelGenerator.field_22830.accept(
                class_4925.method_25770(
                        block,
                        class_4935.method_25824().method_25828(class_4936.field_22887, blockModelId)));
    }

    @Override
    public void generateBlockStateModels(class_4910 blockStateModelGenerator) {
        addSimpleBlock(blockStateModelGenerator, WizcraftBlocks.CRUCIBLE);

        addSimpleBlockWithoutItem(blockStateModelGenerator, WizcraftBlocks.LENS);
        addSimpleBlock(blockStateModelGenerator, WizcraftBlocks.LENSING_PEDESTAL);

        addSimpleBlock(blockStateModelGenerator, WizcraftBlocks.DUMMY_WORKTABLE);
        addWorktableVariant(blockStateModelGenerator, WizcraftBlocks.CRAFTING_WORKTABLE);
        addWorktableVariant(blockStateModelGenerator, WizcraftBlocks.CHARGING_WORKTABLE);
    }

    @Override
    public void generateItemModels(class_4915 itemModelGenerator) {
        itemModelGenerator.method_25733(WizcraftItems.GRIMOIRE, class_4943.field_22938);

        itemModelGenerator.method_25733(WizcraftItems.MORTAR_AND_PESTLE, class_4943.field_22938);

        itemModelGenerator.method_25733(WizcraftItems.WAND_CORE, class_4943.field_22938);
        itemModelGenerator.method_25733(WizcraftItems.METALLIZED_STICK, class_4943.field_22938);

        itemModelGenerator.method_25733(WizcraftItems.WAND, class_4943.field_22940);

        registerFocus(WizcraftItems.CHARGING_FOCUS, itemModelGenerator);
        registerFocus(WizcraftItems.STARSHOOTER_FOCUS, itemModelGenerator);
        registerFocus(WizcraftItems.LIGHTNING_FOCUS, itemModelGenerator);
        registerFocus(WizcraftItems.COMET_WARP_FOCUS, itemModelGenerator);
        registerFocus(WizcraftItems.ENERGY_VEIL_FOCUS, itemModelGenerator);

        itemModelGenerator.method_25733(WizcraftItems.TRUESEER_GOGGLES, class_4943.field_22938);
        itemModelGenerator.method_25733(WizcraftItems.FOCUSES_BELT, class_4943.field_22938);
        itemModelGenerator.method_25733(WizcraftItems.CHARGE_SHELL, class_4943.field_22938);
    }

    private JsonObject createFocusJson(class_2960 id, Map<class_4945, class_2960> textures) {
        var model = class_4943.field_42232.method_48524(id, textures);
        var overrides = new JsonArray();

        for (var plating : FocusPlating.values()) {
            var override = new JsonObject();
            var predicate = new JsonObject();
            predicate.addProperty("wizcraft:focus_plating", plating.index);
            override.add("predicate", predicate);
            override.addProperty("model", DatagenUtil.suffixPlating(id, plating).toString());
            overrides.add(override);
        }

        model.add("overrides", overrides);
        return model;
    }

    private void registerFocus(FocusItem focus, class_4915 generator) {
        class_2960 modelId = class_4941.method_25840(focus);
        class_2960 textureId = class_4944.method_25876(focus);
        class_4943.field_22938.method_48525(modelId, class_4944.method_25895(textureId), generator.field_22844, this::createFocusJson);

        for (var plating : FocusPlating.values()) {
            class_4943.field_42232.method_25852(
                    DatagenUtil.suffixPlating(modelId, plating),
                    class_4944.method_48529(textureId, DatagenUtil.suffixPlating(wid("item/focus"), plating)),
                    generator.field_22844);
        }
    }
}
