package falseresync.wizcraft.datagen;

import falseresync.wizcraft.common.block.WizcraftBlocks;
import falseresync.wizcraft.common.data.WizcraftComponents;
import falseresync.wizcraft.common.item.WizcraftItems;
import falseresync.wizcraft.common.item.focus.FocusPlating;
import falseresync.wizcraft.datagen.recipe.CustomSmithingTransformRecipeJsonBuilder;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricRecipeProvider;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalItemTags;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_2135;
import net.minecraft.class_2248;
import net.minecraft.class_2447;
import net.minecraft.class_2450;
import net.minecraft.class_2960;
import net.minecraft.class_3489;
import net.minecraft.class_7225;
import net.minecraft.class_7800;
import net.minecraft.class_7923;
import net.minecraft.class_8790;
import net.minecraft.class_9326;
import java.util.concurrent.CompletableFuture;

public class WizcraftVanillaRecipeProvider extends FabricRecipeProvider {
    public WizcraftVanillaRecipeProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
        super(output, registriesFuture);
    }

    @Override
    public String method_10321() {
        return "Vanilla Recipes";
    }

    @Override
    public void method_10419(class_8790 exporter) {
        generateCrafting(exporter);
        generateFocusPlating(exporter);
    }

    private void generateCrafting(class_8790 exporter) {
        class_2447.method_10437(class_7800.field_40638, WizcraftItems.MORTAR_AND_PESTLE)
                .method_10433('i', ConventionalItemTags.IRON_NUGGETS)
                .method_10434('f', class_1802.field_8145)
                .method_10434('s', class_1802.field_8291)
                .method_10439("i")
                .method_10439("f")
                .method_10439("s")
                .method_10429("unlock_right_away", class_2135.class_2137.method_49195())
                .method_17972(exporter, item(WizcraftItems.MORTAR_AND_PESTLE));
        class_2450.method_10447(class_7800.field_40638, WizcraftItems.GRIMOIRE)
                .method_10446(ConventionalItemTags.DIAMOND_GEMS)
                .method_10446(ConventionalItemTags.AMETHYST_GEMS)
                .method_10446(ConventionalItemTags.REDSTONE_DUSTS)
                .method_10454(class_1802.field_8529)
                .method_10454(WizcraftItems.MORTAR_AND_PESTLE)
                .method_10442("unlock_right_away", class_2135.class_2137.method_49195())
                .method_17972(exporter, item(WizcraftItems.GRIMOIRE));
        class_2450.method_10447(class_7800.field_40638, WizcraftItems.WAND_CORE)
                .method_10446(ConventionalItemTags.DIAMOND_GEMS)
                .method_10446(ConventionalItemTags.AMETHYST_GEMS)
                .method_10446(ConventionalItemTags.REDSTONE_DUSTS)
                .method_10451(class_1856.method_8091(class_1802.field_8777, class_1802.field_20417))
                .method_10454(WizcraftItems.MORTAR_AND_PESTLE)
                .method_10442("has_diamond", method_10420(ConventionalItemTags.DIAMOND_GEMS))
                .method_10442("has_amethyst", method_10420(ConventionalItemTags.AMETHYST_GEMS))
                .method_17972(exporter, item(WizcraftItems.WAND_CORE));

        class_2447.method_10437(class_7800.field_40638, WizcraftItems.WAND)
                .method_10434('w', WizcraftItems.WAND_CORE)
                .method_10433('g', ConventionalItemTags.GOLD_INGOTS)
                .method_10434('s', WizcraftItems.METALLIZED_STICK)
                .method_10439("  w")
                .method_10439(" g ")
                .method_10439("s  ")
                .method_10429("has_diamond", method_10420(ConventionalItemTags.DIAMOND_GEMS))
                .method_10429("has_amethyst", method_10420(ConventionalItemTags.AMETHYST_GEMS))
                .method_17972(exporter, item(WizcraftItems.WAND));
        class_2447.method_10437(class_7800.field_40638, WizcraftItems.TRUESEER_GOGGLES)
                .method_10433('g', ConventionalItemTags.GOLD_NUGGETS)
                .method_10434('h', class_1802.field_8283)
                .method_10434('p', class_1802.field_8614)
                .method_10433('c', ConventionalItemTags.PRISMARINE_GEMS)
                .method_10439("g g")
                .method_10439("php")
                .method_10439("c c")
                .method_10429("has_phantom_membrane", method_10426(class_1802.field_8614))
                .method_10429("has_prismarine", method_10420(ConventionalItemTags.PRISMARINE_GEMS))
                .method_17972(exporter, item(WizcraftItems.TRUESEER_GOGGLES));
        class_2447.method_10437(class_7800.field_40638, WizcraftItems.FOCUSES_BELT)
                .method_10433('l', ConventionalItemTags.LEATHERS)
                .method_10434('t', class_1802.field_8090)
                .method_10439("ltl")
                .method_10439("l l")
                .method_10439("lll")
                .method_10429("has_turtle_shell", method_10426(class_1802.field_8090))
                .method_17972(exporter, item(WizcraftItems.FOCUSES_BELT));

        class_2447.method_10437(class_7800.field_40634, WizcraftItems.WORKTABLE)
                .method_10433('g', ConventionalItemTags.GOLD_INGOTS)
                .method_10433('l', ConventionalItemTags.LAPIS_GEMS)
                .method_10433('p', class_3489.field_15537)
                .method_10433('s', class_3489.field_15534)
                .method_10439("glg")
                .method_10439(" p ")
                .method_10439("sss")
                .method_10429("has_gold", method_10420(ConventionalItemTags.GOLD_INGOTS))
                .method_17972(exporter, block(WizcraftBlocks.DUMMY_WORKTABLE));
        class_2447.method_10437(class_7800.field_40634, WizcraftItems.LENSING_PEDESTAL)
                .method_10434('l', WizcraftItems.LENS)
                .method_10433('b', class_3489.field_15531)
                .method_10439("l")
                .method_10439("b")
                .method_10439("b")
                .method_10429("has_lens", method_10426(WizcraftItems.LENS))
                .method_17972(exporter, block(WizcraftBlocks.LENSING_PEDESTAL));
    }

    private void generateFocusPlating(class_8790 exporter) {
        generateFocusPlating(exporter, FocusPlating.IRON, class_1856.method_8106(ConventionalItemTags.IRON_INGOTS));
        generateFocusPlating(exporter, FocusPlating.GOLD, class_1856.method_8106(ConventionalItemTags.GOLD_INGOTS));
        generateFocusPlating(exporter, FocusPlating.COPPER, class_1856.method_8106(ConventionalItemTags.COPPER_INGOTS));
    }

    private void generateFocusPlating(class_8790 exporter, FocusPlating plating, class_1856 ingredient) {
        var platingComponents = class_9326.method_57841().method_57854(WizcraftComponents.FOCUS_PLATING, plating.index).method_57852();
        for (var item : WizcraftItemTagProvider.FOCUSES) {
            var stack = new class_1799(item);
            stack.method_59692(platingComponents);
            new CustomSmithingTransformRecipeJsonBuilder(class_1856.field_9017, class_1856.method_8091(item), ingredient, stack)
                    .offerTo(exporter, plating);
        }
    }

    private class_2960 block(class_2248 block) {
        return class_7923.field_41175.method_10221(block);
    }

    private class_2960 item(class_1792 item) {
        return class_7923.field_41178.method_10221(item);
    }
}
