package falseresync.wizcraft.datagen.recipe;

import falseresync.wizcraft.common.recipe.LensedWorktableRecipe;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.minecraft.class_8790;

public class LensedWorktableRecipeJsonBuilder {
    private final class_1792 result;
    private final class_1856 worktableInput;
    private final class_2371<class_1856> pedestalInputs = class_2371.method_10211();

    public LensedWorktableRecipeJsonBuilder(class_1935 result, class_1856 worktableInput) {
        this.result = result.method_8389();
        this.worktableInput = worktableInput;
    }

    public LensedWorktableRecipeJsonBuilder pedestalInput(class_1856 pedestalInput) {
        pedestalInputs.add(pedestalInput);
        return this;
    }

    public void offerTo(class_8790 exporter, class_2960 id) {
        if (pedestalInputs.isEmpty()) {
            throw new IllegalStateException("A Lensed worktable recipe should contain at least one pedestal input");
        }
        var recipe = new LensedWorktableRecipe(new class_1799(result), worktableInput, pedestalInputs);
        exporter.method_53819(id, recipe, null);
    }

    public void offerTo(class_8790 exporter) {
        offerTo(exporter, class_7923.field_41178.method_10221(result).method_45138("lensed_worktable/"));
    }
}
