package falseresync.wizcraft.networking;

import falseresync.wizcraft.common.item.WizcraftItemTags;
import falseresync.wizcraft.common.item.WizcraftItems;
import falseresync.wizcraft.networking.c2s.ChangeWandFocusC2SPayload;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1799;

public class WizcraftServerReceivers {
    public static void register() {
        ServerPlayNetworking.registerGlobalReceiver(ChangeWandFocusC2SPayload.ID, WizcraftServerReceivers::changeWandFocus);
    }

    private static void changeWandFocus(ChangeWandFocusC2SPayload payload, ServerPlayNetworking.Context context) {
        var player = context.player();
        var wandStack = player.method_6047();
        if (!wandStack.method_31573(WizcraftItemTags.WANDS)) {
            return;
        }

        if (payload.slot() < 0) {
            return;
        }

        switch (payload.destination()) {
            case PLAYER_INVENTORY -> {
                if (payload.slot() < player.method_31548().method_5439() - 1) {
                    var newFocusStack = player.method_31548().method_5438(payload.slot());
                    var exchange = WizcraftItems.WAND.exchangeFocuses(wandStack, newFocusStack, player);
                    if (exchange.method_5467().method_23665()) {
                        player.method_31548().method_5447(payload.slot(), exchange.method_5466());
                    }
                } else {
                    var exchange = WizcraftItems.WAND.exchangeFocuses(wandStack, class_1799.field_8037, player);
                    if (exchange.method_5467().method_23665()) {
                        player.method_31548().method_7398(exchange.method_5466());
                    }
                }
            }
            case WAND_INVENTORY -> {
                // do nothing, yet
            }
            case FOCUSES_BELT -> {
                WizcraftItems.FOCUSES_BELT.findTrinketStack(player).ifPresent(beltStack -> {
                    var inventoryComponent = WizcraftItems.FOCUSES_BELT.getOrCreateInventoryComponent(beltStack);
                    if (payload.slot() > inventoryComponent.size() - 1) {
                        return;
                    }

                    var picked = inventoryComponent.stacks().get(payload.slot());
                    var exchange = WizcraftItems.WAND.exchangeFocuses(wandStack, picked, player);
                    if (exchange.method_5467().method_23665()) {
                        var inventory = inventoryComponent.toModifiable();
                        inventory.method_5447(payload.slot(), exchange.method_5466());
                        inventory.flush(beltStack);
                    }
                });
            }
        }
    }
}
