/*
 * Decompiled with CFR 0.152.
 */
package falseresync.lib.blockpattern;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.ints.Int2ObjectRBTreeMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2694;
import net.minecraft.class_4538;

public class BetterBlockPattern {
    protected final Predicate<class_2694>[][][] pattern;
    protected final int width;
    protected final int height;
    protected final int depth;
    protected final int biggestCoordinate;
    protected final int size;
    protected final class_2350[] possibleUp;
    protected final class_2350[] possibleForwards;

    public BetterBlockPattern(Predicate<class_2694>[][][] pattern, boolean preserveUp) {
        class_2350[] class_2350Array;
        this.pattern = pattern;
        this.width = pattern.length;
        this.height = pattern[0].length;
        this.depth = pattern[0][0].length;
        this.biggestCoordinate = Math.max(Math.max(this.width, this.depth), this.height);
        this.size = this.width * this.height * this.depth;
        if (preserveUp) {
            class_2350[] class_2350Array2 = new class_2350[1];
            v1 = class_2350Array2;
            class_2350Array2[0] = class_2350.field_11036;
        } else {
            v1 = this.possibleUp = class_2350.values();
        }
        if (preserveUp) {
            class_2350[] class_2350Array3 = new class_2350[4];
            class_2350Array3[0] = class_2350.field_11043;
            class_2350Array3[1] = class_2350.field_11034;
            class_2350Array3[2] = class_2350.field_11035;
            class_2350Array = class_2350Array3;
            class_2350Array3[3] = class_2350.field_11039;
        } else {
            class_2350Array = class_2350.values();
        }
        this.possibleForwards = class_2350Array;
    }

    public int getSize() {
        return this.size;
    }

    public Match searchAround(class_4538 world, class_2338 startingPos) {
        Int2ObjectRBTreeMap results = new Int2ObjectRBTreeMap(Integer::compareTo);
        LoadingCache cache = Caffeine.newBuilder().build(pos -> new class_2694(world, pos, false));
        for (class_2338 pos2 : class_2338.method_10097((class_2338)startingPos, (class_2338)startingPos.method_10069(this.biggestCoordinate - 1, this.biggestCoordinate - 1, this.biggestCoordinate - 1))) {
            for (class_2350 forwards : this.possibleForwards) {
                for (class_2350 up : this.possibleUp) {
                    if (up == forwards || up == forwards.method_10153()) continue;
                    Match result = this.test(pos2, forwards, up, (LoadingCache<class_2338, class_2694>)cache);
                    if (result.isCompleted()) {
                        return result;
                    }
                    results.put(result.delta.size(), (Object)result);
                }
            }
        }
        return (Match)Objects.requireNonNull(results.firstEntry()).getValue();
    }

    public Match test(class_2338 frontTopLeft, class_2350 forwards, class_2350 up, LoadingCache<class_2338, class_2694> cache) {
        ImmutableList.Builder delta = ImmutableList.builder();
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                for (int z = 0; z < this.depth; ++z) {
                    class_2338 mew = this.changeBasis(frontTopLeft, forwards, up, x, y, z);
                    class_2694 cachedPos = (class_2694)cache.get((Object)mew);
                    if (this.pattern[x][y][z].test(cachedPos)) continue;
                    delta.add((Object)cachedPos);
                }
            }
        }
        return new Match((List<class_2694>)delta.build(), frontTopLeft, forwards, up, this.width, this.height, this.depth, this.size);
    }

    protected class_2338 changeBasis(class_2338 origin, class_2350 forwards, class_2350 up, int x, int y, int z) {
        Preconditions.checkArgument((up != forwards && up != forwards.method_10153() ? 1 : 0) != 0, (String)"Invalid combination of forwards and up: %s and %s", (Object)forwards, (Object)up);
        class_2382 localOZ = forwards.method_10163();
        class_2382 localOY = up.method_10163();
        class_2382 localOX = localOY.method_10259(localOZ);
        return origin.method_10059(new class_2382(localOX.method_10263() * x + localOY.method_10263() * y + localOZ.method_10263() * z, localOX.method_10264() * x + localOY.method_10264() * y + localOZ.method_10264() * z, localOX.method_10260() * x + localOY.method_10260() * y + localOZ.method_10260() * z));
    }

    public record Match(List<class_2694> delta, List<class_2338> deltaAsBlockPos, class_2338 frontTopLeft, class_2350 forwards, class_2350 up, int width, int height, int depth, int size) {
        public Match(List<class_2694> delta, class_2338 frontTopLeft, class_2350 forwards, class_2350 up, int width, int height, int depth, int size) {
            this(delta, delta.stream().map(class_2694::method_11683).toList(), frontTopLeft, forwards, up, width, height, depth, size);
        }

        public boolean isCompleted() {
            return this.delta.isEmpty();
        }

        public boolean isHalfwayCompleted() {
            return (double)Math.abs(this.delta.size() - this.size) / (double)this.size > 0.5;
        }
    }
}

